import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Button, message } from 'antd'
import styles from '../edits.less'
import { TurntableType as type } from 'wp/utils/itemType'
import Editor from 'wp/constructors/editor/index'
import TurntableEditorModel from './turntable-editor-model'
import { observer } from 'mobx-react'

const TabPane = Tabs.TabPane

@Editor({
  type,
  basic: {
    border: 'hidden',
    transform: 'hidden',
    borderRadius: 'hidden',
    opacity: 'hidden',
    size: 'disabled',
    rotate: 'hidden'
  }
})
@observer
export default class TurntableEditor extends Component {
  state = {
    isShowModel: false
  };

  hideModel = () => {
    // 判断概率总和是否为1
    let total = this.props.target.awardSetting.reduce((acc, item) => {
      return acc + item.probability
    }, 0)
    if (total > 1) {
      message.warn('概率总和不能大于100%')
    } else {
      this.setState({
        isShowModel: false
      })
    }
  }
  showModel = () => {
    this.setState({
      isShowModel: true
    })
  }
  render () {
    const { isShowModel } = this.state
    const { target, BasicAttrsCom, WidgetNameCom } = this.props

    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey='1' style={{ height: '100%' }}>
          <TabPane tab='组件' key='1'>
            <Form layout='inline'>
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row style={{ marginBottom: '8px', paddingTop: '10px' }}>
                <Col offset={1} span={22}>
                  <Button type='primary' onClick={this.showModel}>编辑组件</Button>
                </Col>
              </Row>
              {BasicAttrsCom}
              {isShowModel && <TurntableEditorModel hideModel={this.hideModel} target={target} />}
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
