import React, { Component } from 'react'
import Widget from 'wp/constructors/widget/index'
import store from 'wp/store'
import MobileElement from './element'

// 闭包内的局部变量,被所有部件共用
let removeHandlers = {}
@Widget({
  onWidgetMount({ targetId }) {
    // 注册钩子
    removeHandlers[targetId] = store.WPHookStore.addHook(
      'onSceneInnerHeightChangeEnd',
      () => {
        const fixedType = store.WPSceneStore.getItemPropById(targetId, 'fixed')
        if (['none', 'top'].indexOf(fixedType.type) !== -1) return
        store.WPSceneStore.changeItemPropsById(targetId, {
          'style.bottom': '0px',
          'style.top': 'auto'
        })
      }
    )
  },
  onWidgetWillUnmount({ targetId }) {
    // 注销钩子
    removeHandlers[targetId]()
  }
})
export default class MobileWidget extends Component {
  render() {
    const { widgetAttrs, changeMover } = this.props
    const { fixed } = widgetAttrs
    if (fixed.type !== 'none') {
      changeMover('top', false)
      changeMover('left', false)
    } else {
      changeMover('top', true)
      changeMover('left', true)
    }
    return <MobileElement widgetAttrs={this.props.widgetAttrs} />
  }
}
