import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Upload, message, Button, Input, Radio, Switch } from 'antd'
import styles from '../edits.less'
import EditStyles from './index.less'
import { formItemProps } from '../helper'
import { MobileType as type } from 'wp/utils/itemType'
import Editor from 'wp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import { unset } from 'lodash-es'
import {
  beforeUploadGen,
  uploadStatusChangeGen,
  uploadParamsGen,
  staticResourcePrefix
} from 'wp/config'
import { readImageProps, getNetUrl } from 'wp/utils/helper'
import ColorPicker from 'pro/components/color-picker'
import TuiaIcon from 'wp/constructors/fc/icon'

const FormItem = Form.Item
const TabPane = Tabs.TabPane
const RadioGroup = Radio.Group

@Editor({
  type,
  basic: {
    border: 'hidden',
    transform: 'hidden',
    borderRadius: 'hidden',
    opacity: 'hidden',
    rotate: 'hidden'
  }
})
@inject('WPSceneStore')
@observer
export default class MobileEditor extends Component {
  handleFastStyleClick = (props, borderRadius) => {
    props.handleChange({
      'style.borderBottomLeftRadius': borderRadius,
      'style.borderBottomRightRadius': borderRadius,
      'style.borderTopLeftRadius': borderRadius,
      'style.borderTopRightRadius': borderRadius,
      'style.backgroundImage': '',
      'style.width': '240px',
      'style.height': '38px',
      'icon.style.display': 'inline-block',
      'text': '拨打电话',
      'style.backgroundColor': '#EA5422'
    })
  }

  render() {
    const { target, BasicAttrsCom, handleChange, WidgetNameCom } = this.props
    const ImageStyle = Object.assign({}, target.style, {
      maxWidth: '100%',
      maxHeight: '100%'
    })
    unset(ImageStyle, 'left')
    unset(ImageStyle, 'top')
    unset(ImageStyle, 'transform')
    unset(ImageStyle, 'zIndex')
    unset(ImageStyle, 'position')
    unset(ImageStyle, 'cursor')
    const { style, text, mobile, fixed } = target
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="拨打电话" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row style={{marginBottom: 4}}>
                <Col offset={1} span={22}>
                  <div className={EditStyles['uploader']} style={{ backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")` }}>
                    {!ImageStyle.backgroundImage ? (
                      <div style={ImageStyle} className="DemoButton">
                        <TuiaIcon type='control_phone' style={{ marginRight: 16 }} />
                        {target.text}
                      </div>
                    ) : (
                      <img
                        src={ImageStyle.backgroundImage.replace(
                          /url\("([\s\S]*)"\)/,
                          (_, matches) => matches
                        )}
                        style={{ maxWidth: '100%', maxHeight: '100%' }}
                      />
                    )}
                  </div>
                </Col>
              </Row>
              <FormItem label="快捷样式" {...formItemProps}>
                <Row
                  type="flex"
                  justify="space-around"
                  align="middle"
                >
                  <Col style={{ width: 40 }}>
                    <div
                      className={EditStyles['fastStyle']}
                      onClick={() => this.handleFastStyleClick(this.props, '0px')}
                      style={{
                        backgroundImage: `url(${staticResourcePrefix}/radius-0px.svg)`,
                        backgroundSize: 'cover'
                      }}
                    />
                  </Col>
                  <Col style={{ width: 40 }}>
                    <div
                      className={EditStyles['fastStyle']}
                      onClick={() => this.handleFastStyleClick(this.props, '8px')}
                      style={{
                        backgroundImage: `url(${staticResourcePrefix}/radius-8px.svg)`,
                        backgroundSize: 'cover'
                      }}
                    />
                  </Col>
                  <Col style={{ width: 40 }}>
                    <div
                      className={EditStyles['fastStyle']}
                      onClick={() => this.handleFastStyleClick(this.props, '32px')}
                      style={{
                        backgroundImage: `url(${staticResourcePrefix}/radius-32px.svg)`,
                        backgroundSize: 'cover'
                      }}
                    />
                  </Col>
                  <Col style={{ width: '60px' }}>
                    <Upload
                      {...{
                        ...uploadParamsGen(),
                        showUploadList: false,
                        beforeUpload: beforeUploadGen(),
                        onChange: uploadStatusChangeGen(info => {
                          if (info.file.status === 'done') {
                            const netUrl = getNetUrl(info.file.name)
                            const { dpr } = this.props.WPSceneStore.scene
                            handleChange({
                              'style.backgroundImage': `url("${netUrl}")`,
                              'icon.style.display': 'none',
                              'text': '',
                              'style.backgroundColor': 'rgba(0,0,0,0)'
                            })
                            // resize图片尺寸
                            readImageProps(netUrl).then(res => {
                              handleChange({
                                'style.width': res.width / dpr + 'px',
                                'style.height': res.height / dpr + 'px'
                              })
                            })
                          } else if (info.file.status === 'error') {
                            message.error(`${info.file.name}。文件上传失败`)
                          }
                        })
                      }}
                    >
                      <Button type="primary">上传</Button>
                    </Upload>
                  </Col>
                </Row>
              </FormItem>
              <FormItem label="按钮颜色" {...formItemProps}>
                <div style={{ height: 39, width: 56, display: 'flex', alignItems: 'center' }}>
                  <ColorPicker
                    value={style.backgroundColor}
                    onChange={color => handleChange({ 'style.backgroundColor': color })}
                  />
                </div>
              </FormItem>
              <FormItem label="电话" {...formItemProps}>
                <Input
                  value={mobile}
                  onChange={e => handleChange({ mobile: e.target.value })}
                />
              </FormItem>
              <FormItem label="按钮文案" {...formItemProps}>
                <Input
                  value={text}
                  onChange={e => handleChange({ text: e.target.value })}
                />
              </FormItem>
              <FormItem label="固定悬浮" {...formItemProps}>
                <RadioGroup
                  value={fixed.type}
                  onChange={e => {
                    let obj = {
                      'fixed.type': e.target.value
                    }
                    if (e.target.value === 'bottom') {
                      obj['style.top'] = 'auto'
                      obj['cachetop'] = style.top
                      obj['style.bottom'] = '0px'
                    } else {
                      if (target.cachetop) {
                        obj['style.top'] = target.cachetop
                        obj['cachetop'] = false
                      }
                      obj['style.bottom'] = 'auto'
                    }
                    handleChange(obj)
                  }}
                >
                  <Radio value="bottom">
                    底部
                  </Radio>
                  <Radio value="self">
                    自定义
                  </Radio>
                  <Radio value="none">
                    无
                  </Radio>
                </RadioGroup>
              </FormItem>
              <FormItem label="设为转化" {...formItemProps}>
                <Switch
                  checked={target.jump.isCoversion === undefined ? true : Boolean(target.jump.isCoversion)}
                  onChange={value => handleChange({ 'jump.isCoversion': value ? 1 : 0 })}
                />
              </FormItem>
              {BasicAttrsCom}
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
