import Util from '../libs/utils'
import toast from '../libs/toast'

/**
 * 表单唯一值校验
 * @param {Array} controlSetting 表单项配置项
 * @param {Object} data 表单数据
 */
const verifyUnique = function(controlSetting, data) {
  let hasUnique = false
  let unique = {
    landId: parseInt(window.atob(Util.getUrlParameter('id')))
  }

  // data 字段转换
  const _data = {}
  for (let i in data) {
    if (i.indexOf('input_mobile') !== -1 || i.indexOf('input_idcard') !== -1 || i.indexOf('isUnique') !== -1) {
      _data[i.split('-')[0]] = data[i].split('-')[0]
    }
  }

  controlSetting.forEach(item => {
    if (item.childType === 'mobile' && item.isUnique) {
      unique['userPhone'] = _data.input_mobile
      hasUnique = true
    }
    if (item.childType === 'idcard' && item.isUnique) {
      unique['identification'] = _data.input_idcard
      hasUnique = true
    }
    if (item.childType === 'email' && item.isUnique) {
      unique['email'] = _data.input_email
      hasUnique = true
    }
  })

  return new Promise((resolve, reject) => {
    if (hasUnique) {
      Util.ajax({
        url: '/activity/land/checkUniqueness',
        method: 'post',
        data: unique
      })
        .then(res => {
          if (res.success) {
            let error = ''
            if (res.data.identification) {
              error = '身份证号码重复'
            } else if (res.data.email) {
              error = '邮箱重复'
            } else if (res.data.userPhone) {
              error = '手机号重复'
            }
            if (error) {
              toast(error)
              reject(error)
            } else {
              resolve()
            }
          } else {
            toast(res.desc)
            reject(res.desc)
          }
        })
        .catch(err => {
          reject(err)
        })
    } else {
      resolve()
    }
  })
}

export default verifyUnique
