import React from 'react'
import { Checkbox } from 'antd-mobile'
import Util from '../../libs/utils'

export default class RadioNormal extends React.Component {
  componentDidMount() {}

  handleChange = value => {
    let result = this.props.value
    const index = result.findIndex(item => {
      return item === value
    })

    if (index !== -1) {
      result.splice(index, 1)
    } else {
      result.push(value)
    }

    this.props.onChange(result)
  }

  isChecked = value => {
    const result = Util.inArray(this.props.value, value)
    return result
  }

  render() {
    const { title, options } = this.props.formAttrs

    // 自定义下拉选项
    let radioOptions = options ? options.split('\n') : []
    if (radioOptions) {
      radioOptions = radioOptions.map(item => {
        return {
          label: item,
          value: item
        }
      })
    }

    return (
      <div className="list-input-item">
        <div className="list-input-item-label">{title}</div>
        <div className="list-input-item-content">
          {radioOptions.map(i => (
            <Checkbox
              className="checkbox-tag"
              key={i.value}
              checked={this.isChecked(i.value)}
              onChange={() => this.handleChange(i.value)}
            >
              <span className="checkbox-value">{i.value}</span>
            </Checkbox>
          ))}
        </div>
      </div>
    )
  }
}
