import React, { Component } from 'react'
import Widget from 'wp/constructors/widget/index'
import store from 'wp/store'

// 闭包内的局部变量,被所有部件共用
let removeHandlers = {}

@Widget({
  resizer: {
    ro: 'hidden',
    ct: 'hidden',
    lt: 'hidden',
    rt: 'hidden',
    rm: 'hidden',
    rb: 'hidden',
    cb: 'hidden',
    lb: 'hidden',
    lm: 'hidden'
  },
  mover: {
    left: false,
    top: false
  },
  onWidgetMount({ targetId }) {
    // 注册钩子
    removeHandlers[targetId] = store.WPHookStore.addHook(
      'onSceneInnerHeightChangeEnd',
      () => {
        const fixedType = store.WPSceneStore.getItemPropById(
          targetId,
          'fixedType'
        )
        if (!fixedType) return
        store.WPSceneStore.changeItemPropsById(targetId, {
          'style.left': 0,
          ...(fixedType === 'bottom'
            ? { 'style.bottom': '0px', 'style.top': 'auto' }
            : { 'style.top': '0px', 'style.bottom': 'auto' })
        })
      }
    )
  },
  onWidgetWillUnmount({ targetId }) {
    // 注销钩子
    removeHandlers[targetId]()
  }
})
export default class DownloadWidget extends Component {
  render() {
    const { fixed } = this.props.widgetAttrs
    const { changeMover } = this.props
    fixed.type === '' ? changeMover('top', true) : changeMover('top', false)
    return <React.Fragment />
  }
}
