import React, { Component } from 'react'
import { Tabs, Row, Col, Upload, Select, InputNumber } from 'antd'
import styles from '../edits.less'
import { pxFormatter } from '../helper'
import { DownloadType as type } from 'wp/utils/itemType'
import {
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen
} from 'wp/config'
import { getNetUrl, getNumber, readImageProps } from 'wp/utils/helper'
import { unset } from 'lodash-es'
import Editor from 'wp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import Divider from 'wp/constructors/fc/divider'

const TabPane = Tabs.TabPane
const Option = Select.Option
const Dragger = Upload.Dragger

@Editor({
  type,
  basic: {
    border: 'hidden',
    transform: 'hidden',
    borderRadius: 'hidden',
    opacity: 'hidden',
    size: 'disabled',
    rotate: 'hidden',
    jump: {
      noDivider: true
    }
  }
})
@inject('WPSceneStore')
@observer
export default class DownloadEditor extends Component {
  render() {
    const { target, handleChange, WidgetNameCom, JumpCom } = this.props
    const { dpr } = this.props.WPSceneStore.scene
    const DownloadStyle = Object.assign({}, target.style, {
      maxWidth: '100%',
      maxHeight: '100%'
    })
    unset(DownloadStyle, 'width')
    unset(DownloadStyle, 'height')
    unset(DownloadStyle, 'top')
    unset(DownloadStyle, 'left')
    unset(DownloadStyle, 'position')
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="下载悬浮" key="1">
            <React.Fragment>
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row style={{ marginBottom: '13px' }}>
                <Col offset={1} span={22}>
                  <Dragger
                    {...{
                      ...uploadParamsGen(),
                      showUploadList: false,
                      className: 'popup-uploader',
                      multiple: false,
                      beforeUpload: beforeUploadGen(),
                      onChange: uploadStatusChangeGen(info => {
                        if (info.file.status === 'done') {
                          const netUrl = getNetUrl(info.file.name)
                          this.props.handleChange({
                            'style.backgroundImage': `url("${netUrl}")`,
                            'style.width': '200px'
                          })
                          // resize图片尺寸
                          readImageProps(netUrl).then(res => {
                            this.props.handleChange({
                              'style.width': res.width / dpr + 'px',
                              'style.height': res.height / dpr + 'px'
                            })
                          })
                        }
                      })
                    }}
                  >
                    {DownloadStyle.backgroundImage ? (
                      <img
                        src={DownloadStyle.backgroundImage.replace(
                          /url\("([\s\S]*)"\)/,
                          (_, matches) => matches
                        )}
                        style={{ maxWidth: '100%', maxHeight: '500px' }}
                      />
                    ) : (
                      <div className="draggerUpload">
                        <p className="ant-upload-text">拖拽图片至此区域</p>
                        <p className="ant-upload-hint">支持格式：JPG/PNG/GIF</p>
                        <p className="ant-upload-hint">文件大小：&lt; 1M</p>
                      </div>
                    )}
                  </Dragger>
                </Col>
              </Row>
              <Row type="flex" align="middle" style={{ marginBottom: '13px' }}>
                <Col offset={1} span={5} style={{ fontSize: 12 }}>
                  宽度距离
                </Col>
                <Col span={8}>
                  <Select
                    value={target.fixed.horizontal}
                    style={{ width: '100%' }}
                    onChange={value => {
                      handleChange({
                        ...(value === 'right'
                          ? {
                            'style.left': 'auto',
                            'style.right': '0px',
                            'fixed.horizontal': 'right'
                          }
                          : {
                            'style.left': '0px',
                            'style.right': 'auto',
                            'fixed.horizontal': 'left'
                          })
                      })
                    }}
                  >
                    <Option value="left">相对左侧</Option>
                    <Option value="right">相对右侧</Option>
                  </Select>
                </Col>
                <Col offset={1} span={8}>
                  <InputNumber
                    value={
                      parseFloat(target.style[target.fixed.horizontal]) * dpr
                    }
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    onChange={value => {
                      handleChange({
                        [`style.${target.fixed.horizontal}`]: value / dpr + 'px'
                      })
                    }}
                  />
                </Col>
              </Row>
              <Row type="flex" align="middle" style={{ marginBottom: '13px' }}>
                <Col offset={1} span={5} style={{ fontSize: 12 }}>
                  高度距离
                </Col>
                <Col span={8}>
                  <Select
                    value={target.fixed.type}
                    style={{ width: '100%' }}
                    onChange={value => {
                      handleChange({
                        ...(value === 'top'
                          ? {
                            'style.bottom': 'auto',
                            'style.top': '0px',
                            'fixed.type': 'top'
                          }
                          : {
                            'style.bottom': '0px',
                            'style.top': 'auto',
                            'fixed.type': 'bottom'
                          })
                      })
                    }}
                  >
                    <Option value="top">相对顶部</Option>
                    <Option value="bottom">相对底部</Option>
                  </Select>
                </Col>
                <Col offset={1} span={8}>
                  <InputNumber
                    value={parseFloat(target.style[target.fixed.type]) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    onChange={value => {
                      handleChange({
                        [`style.${target.fixed.type}`]: value / dpr + 'px'
                      })
                    }}
                  />
                </Col>
              </Row>
              <Row type="flex" align="middle" style={{ marginBottom: '13px' }}>
                <Col offset={1} span={5} style={{ fontSize: 12 }}>
                  图案验证
                </Col>
                <Col span={17}>
                  <Select
                    value={target.picValid}
                    style={{ width: '100%' }}
                    onChange={value => {
                      handleChange({ picValid: value })
                    }}
                  >
                    <Option value={1}>是</Option>
                    <Option value={0}>否</Option>
                  </Select>
                </Col>
              </Row>
              <Divider />
              {JumpCom}
              <Divider />
              <Row type="flex" align="middle" style={{ height: 39 }}>
                <Col span={2} offset={4}>
                  X
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(target.style.left) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    disabled
                  />
                </Col>
                <Col span={2} offset={3}>
                  Y
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(target.style.top) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    step={dpr}
                    disabled={target.fixed.type !== ''}
                    onChange={value =>
                      handleChange({ 'style.top': value / dpr + 'px' })
                    }
                  />
                </Col>
              </Row>
              <Row type="flex" align="middle" style={{ height: 39 }}>
                <Col span={2} offset={4}>
                  宽
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(target.style.width) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    min={0}
                    disabled
                  />
                </Col>
                <Col span={2} offset={3}>
                  高
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(target.style.height) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    min={0}
                    disabled
                  />
                </Col>
              </Row>
            </React.Fragment>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
