import React, { Component } from 'react'
import Item from 'wp/constructors/item/index'
import ItemsStyle from '../items.less'
import { AddressType as type } from 'wp/utils/itemType'
import defaultAttrs from './attrs'
import { AddressScreenshot as screenshot } from 'wp/config/dragScreenshot'
import TuiaIcon from 'wp/constructors/fc/icon'

@Item({
  type,
  defaultAttrs,
  screenshot,
  horizontalCenter: true
})
export default class AddressItem extends Component {
  render () {
    return (
      <div className={ItemsStyle['item']}>
        <TuiaIcon type='control_address' />
        地址
      </div>
    )
  }
}
