/*
 * @Author: chenhaojie
 * @Date: 2018-07-19 14:52:49
 * @LastEditors: chenhaojie
 * @LastEditTime: 2018-07-20 11:16:15
 * @Description: drag工具类
 * @Email: chenhaojie@tuia.cn
 */
import React, { Component } from 'react'
import { DragDropContext } from 'react-dnd'
import HTML5Backend from 'react-dnd-html5-backend'

// HTML5BackEnd 用于监听以及处理拖拽相关事件
export function generateDragDropContext () {
  @DragDropContext(HTML5Backend)
  class DragDropContainer extends Component {
    render () {
      return <div data-dragdropcontenxt>{this.props.children}</div>
    }
  }
  return DragDropContainer
}
