import React, { Component } from 'react'
import { Modal } from 'antd'
import CodeMirror from 'react-codemirror'
import 'codemirror/lib/codemirror.css'
import { observer } from 'mobx-react'
import store from 'wp/store'

@observer
export default class extends Component {
  state = {
    modalVisible: false
  }
  render() {
    const SceneStore = store.WPSceneStore
    const { code } = SceneStore.scene
    return (
      <div>
        <a href="javascript:;" onClick={() => this.setState({ modalVisible: true })}>自定义代码</a>
        <Modal
          title={null}
          footer={null}
          visible={this.state.modalVisible}
          bodyStyle={{ padding: 0 }}
          onCancel={() => this.setState({ modalVisible: false })}
        >
          <CodeMirror
            value={code}
            onChange={newCode => {
              SceneStore.changeSceneProps({
                code: newCode
              })
            }}
            options={{
              mode: 'javascript',
              lineNumbers: true
            }} />
        </Modal>
      </div>
    )
  }
}
