import React, { Component } from 'react'
import styles from './index.less'
import Ruler from 'wp/constructors/ruler/index.js'
import { bodySizes, bodyInnerUniqueId } from 'wp/config'

const reverterSize = bodySizes.corner.size
let ruler1
let ruler2

export default class RulerContainer extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      isOriginPos: true
    }
  }
  componentDidMount() {
    setTimeout(() => {
      const bodyRect = document
        .getElementById('__body__')
        .getBoundingClientRect()
      const { width, height } = bodyRect
      ruler1 = new Ruler({
        id: 'horizontalRuler',
        minValue: 0,
        maxValue: 1000,
        width: width - reverterSize,
        height: reverterSize,
        type: 'horizontal'
      })
      ruler1.draw()
      const rulerIndicatorXDom = document.getElementById('rulerIndicatorX')
      ruler1.onMouseMove = (e, value) => {
        rulerIndicatorXDom.style.display !== 'block' &&
          (rulerIndicatorXDom.style.display = 'block')
        rulerIndicatorXDom.style.left = e.offsetX + reverterSize + 'px'
        rulerIndicatorXDom.children[0].innerText = value
      }
      ruler1.onMouseOut = () => {
        rulerIndicatorXDom.style.display = 'none'
      }
      ruler2 = new Ruler({
        id: 'verticalRuler',
        minValue: 0,
        maxValue: 11000,
        width: reverterSize,
        height: height - reverterSize,
        type: 'vertical'
      })
      ruler2.draw()
      const rulerIndicatorYDom = document.getElementById('rulerIndicatorY')
      ruler2.onMouseMove = (e, value) => {
        rulerIndicatorYDom.style.display !== 'block' &&
          (rulerIndicatorYDom.style.display = 'block')
        rulerIndicatorYDom.style.top = e.offsetY + reverterSize + 'px'
        rulerIndicatorYDom.children[0].innerText = value
      }
      ruler2.onMouseOut = () => {
        rulerIndicatorYDom.style.display = 'none'
      }
    }, 0)

    // 当前窗口发生变化时重绘ruler
    let resizeHandler = () => {
      const bodyRect = document
        .getElementById('__body__')
        .getBoundingClientRect()
      const { width, height } = bodyRect
      const { scrollTop, scrollLeft } = document.getElementById(
        bodyInnerUniqueId
      )
      ruler1.reDraw({
        start: scrollLeft,
        width: width - reverterSize
      })
      ruler2.reDraw({
        start: scrollTop,
        height: height - reverterSize
      })
    }
    window.addEventListener('resize', resizeHandler)

    const bodyInner = document.getElementById(bodyInnerUniqueId)

    // 定制滚动区域滚动事件
    bodyInner.addEventListener('mousewheel', function(e) {
      const { height } = bodyInner.getBoundingClientRect()
      const { deltaY } = e
      // const ruler1Start = ruler1.options.start + deltaX
      const ruler2Start = ruler2.options.start + deltaY
      // const ruler1Max = bodySizes.sceneContainer.width - width
      const ruler2Max = bodySizes.sceneContainer.height - height
      // 重绘水平方向ruler
      // ruler1.reDraw({
      //   start: ruler1Start <= 0 ? 0 : ruler1Start >= ruler1Max ? ruler1Max : ruler1Start
      // })
      // 重绘垂直方向ruler
      ruler2.reDraw({
        start:
          ruler2Start <= 0
            ? 0
            : ruler2Start >= ruler2Max
              ? ruler2Max
              : ruler2Start
      })
      // 设置bodyInner的滚动条位置
      bodyInner.scrollTop += deltaY
      // bodyInner.scrollLeft += deltaX
    })
  }
  reduction() {
    const bodyInner = document.getElementById(bodyInnerUniqueId)
    // 重绘水平方向ruler
    ruler1.reDraw({
      start: 0
    })
    // 重绘垂直方向ruler
    ruler2.reDraw({
      start: 0
    })
    // 设置bodyInner的滚动条位置
    bodyInner.scrollTop = 0
    bodyInner.scrollLeft = 0
  }
  render() {
    return (
      <div className={styles['rulerContainer']}>
        <div id="horizontalRuler" />
        <div id="verticalRuler" />
        <div
          className={styles['reverter']}
          style={{ width: reverterSize + 'px', height: reverterSize + 'px' }}
          onClick={this.reduction}
        />
        <div
          className={styles['indicator']}
          style={{ left: 0, right: 0, height: '1px' }}
          id="rulerIndicatorY"
        >
          <div
            style={{
              transform: 'translate(-2px, -12px) rotate(-90deg)',
              transformOrigin: '5px 0'
            }}
          >
            0
          </div>
        </div>
        <div
          className={styles['indicator']}
          style={{ top: 0, bottom: 0, width: '1px' }}
          id="rulerIndicatorX"
        >
          <div style={{ marginLeft: '5px' }}>0</div>
        </div>
      </div>
    )
  }
}
