import React, { Component } from 'react'
import Scene from './scene'
import styles from './index.less'
import Ruler from './ruler'
import { bodyInnerUniqueId } from 'wp/config'

export default class Body extends Component {
  handleMouseMove (e) {
    // 调节scene高度handle
    typeof window.__SceneMouseMove__ === 'function' && window.__SceneMouseMove__(e.clientY)
  }
  handleMouseUp (e) {
    // 调节scene高度handle
    typeof window.__SceneMouseUp__ === 'function' && window.__SceneMouseUp__(e.clientY)
  }
  render () {
    return (
      <React.Fragment>
        <Ruler />
        <div
          id={bodyInnerUniqueId}
          className={styles['body-inner']}
          onMouseMove={this.handleMouseMove}
          onMouseUp={this.handleMouseUp}
        >
          {/* // TODO 此处可扩展从而支持多Scene同时编辑 */}
          <Scene />
        </div>
      </React.Fragment>
    )
  }
}
