import React, { Component } from 'react'
import { inject } from 'mobx-react'
import { hot } from 'react-hot-loader'
// import cacheNotify from 'wp/features/cache-notify'
import resetStore from 'wp/features/reset-store'
import clearSnapshot from 'wp/features/clear-snapshot'
// import { cachePageOnUnload, applyCachedPage } from 'wp/features/ls-cache'
import { SteppableGuide } from 'wp/features/guide'
import { Step1, Step2, Step3, Step4 } from 'wp/guides'
import Layout from './layout/holy-grail'
import keyListen from 'wp/features/key-listen'
import Loading from 'wp/features/loading'

import * as types from 'wp/utils/itemType'
import store from 'wp/store'
import hookStore from 'wp/store/hook'
import {
  removeLocalStorage,
  getLocalStorage,
  getNumber,
  versionInvalid
} from 'wp/utils/helper'
import { getJson, getAllTags } from './api'
import { notification, Icon } from 'antd'
import { version as rootVersion } from '../../version.json'

const { WPSceneStore } = store

@inject('WPSceneStore')
class Workplace extends Component {
  constructor() {
    super(...arguments)
    this.ref = React.createRef()
  }
  init() {
    // 通过new-page组件传来的初始化数据渲染工作台
    let createScene = getLocalStorage('createScene')
    if (createScene) {
      store.WPHookStore.walkHooks('onSceneInnerWidthChangeEnd', {
        width: getNumber(createScene.width)
      })
      store.WPSceneStore.init(createScene)
      removeLocalStorage('createScene')
    }
    getAllTags().then(res => {
      store.WPSceneStore.changeTags(res.data)
    })
    // 通过复制或编辑的入口进入，需要加载远程数据
    const pageId = getLocalStorage('pageId')
    const isCopy = getLocalStorage('isCopy')
    if (!pageId) {
      WPSceneStore.version = rootVersion
      return
    }
    Loading.show()
    getJson(pageId).then(res => {
      try {
        if (res.code === 0) {
          if (res.data) {
            const { promoteTag } = res.data
            // 编辑或复制逻辑
            let { page, elements, version } = JSON.parse(res.data.pageJson)
            WPSceneStore.version = version
            // 版本号提示
            // 只对无版本和1.0.0版本的进行提示，2.0.0版本开始逻辑各走各的
            const pageVersion = version || '0'
            if (version === '2.0.0') {
            } else if (versionInvalid('1.0.0', pageVersion)) {
              this.versionNotification()
            }

            // 组装适用于管理端的数据结构
            const itemList = elements.map(item => {
              if (item.type === types.PopupType) {
                return {
                  widgetType: item.type,
                  targetId: item.id,
                  [item.type]: {
                    ...item,
                    elements:
                      item.elements &&
                      item.elements.map(el => {
                        return {
                          widgetType: el.type,
                          targetId: el.id,
                          [el.type]: {
                            ...el,
                            // 使用原始定位信息回显
                            style: el.originalStyle
                          }
                        }
                      })
                  }
                }
              }
              return {
                widgetType: item.type,
                targetId: item.id,
                [item.type]: item
              }
            })
            if (isCopy) {
              removeLocalStorage('pageId')
              page.name += '-复制'
            }
            WPSceneStore.init(page, itemList)
            WPSceneStore.changePromoteTag(
              (promoteTag && promoteTag.split(',')) || []
            )
            // onInit钩子调用
            hookStore.walkHooks('onInit', { page })
          } else {
            // 新建页面逻辑
          }
          removeLocalStorage('isCopy')
        } else {
          // 请求接口失败逻辑
        }
      } catch (e) {
        console.log(e)
      }
      Loading.cancel()
    })
  }
  componentDidMount() {
    // cacheNotify()
    // 关闭浏览器tab前保存副本
    // cachePageOnUnload()
    // 应用本地缓存
    // applyCachedPage()
    // 重置store
    resetStore()
    // 清除快照（必须在重置store之后执行）
    clearSnapshot()
    // 键盘事件监听
    this.keydownListenRemover = keyListen()
    // 新手引导
    this.timer = setTimeout(() => {
      this.ref.current.setup({
        guides: [
          {
            id: 'guide1',
            mode: 'step',
            theme: 'emphasized',
            steps: [
              {
                src: '//yun.tuia.cn/tuia/jimo-web-pro/navigator1.gif',
                text: <Step1 />,
                placement: 'right',
                domSelector: '#__aside_left__',
                introOffset: {
                  top: 30,
                  left: 18
                },
                arrowOffset: {
                  top: 100
                }
              },
              {
                src: '//yun.tuia.cn/tuia/jimo-web-pro/navigator2.gif',
                text: <Step2 />,
                placement: 'left',
                domSelector: '#__aside_right__',
                introOffset: {
                  top: 30,
                  right: 18
                },
                arrowOffset: {
                  top: 100
                }
              },
              {
                src: '//yun.tuia.cn/tuia/jimo-web-pro/navigator3.gif',
                text: <Step3 />,
                placement: 'bottom',
                domSelector: '#__page_operation_btns__',
                introOffset: {
                  top: 20,
                  left: -140
                }
              },
              {
                src: '//yun.tuia.cn/tuia/jimo-web-pro/navigator4.gif',
                text: <Step4 />,
                placement: 'bottom',
                domSelector: '#___preview_btn___',
                introOffset: {
                  top: 20,
                  left: -360
                }
              }
            ]
          }
        ]
      })
      clearTimeout(this.timer)
    }, 2000)
    this.init()
  }
  componentWillUnmount() {
    this.keydownListenRemover && this.keydownListenRemover()
    clearTimeout(this.timer)
  }
  versionNotification = () => {
    notification.open({
      message: '版本已过旧',
      description:
        '当前页面版本已过旧，将无法使用部分最新功能，建议重新创建新页面！如重新编辑，为避免出现页面问题，请重新预览后再发布！！！',
      icon: <Icon type="warning" style={{ color: 'red' }} />,
      duration: 10
    })
  }
  render() {
    return (
      <div id="__pro_workplace__" onContextMenu={e => e.preventDefault()}>
        <Layout />
        <SteppableGuide ref={this.ref} />
      </div>
    )
  }
}
export default hot(module)(Workplace)
