import React, { Component } from 'react'
import ReactCSS from 'reactcss'

export default class Perspector extends Component {
  render() {
    const { config, index } = this.props
    const child = config.steps[index]
    let domRect = document.querySelector(child.domSelector).getBoundingClientRect()
    const StepStyles = ReactCSS(
      {
        default: {
          'guide-perspective': {
            position: 'absolute',
            width: domRect.width + 'px',
            height: domRect.height + 'px',
            top: domRect.top,
            left: domRect.left
          },
          'guide-perspective-inner': {
            height: '100%',
            width: '100%'
          }
        },
        emphasized: {
          'guide-perspective': {
            boxShadow: 'rgba(0, 0, 0, 0.6) 0px 0px 1px 10000px'
          },
          'guide-perspective-inner': {
            boxShadow: 'inset 0 0 2px 2px rgba(0, 0, 0, 0.6)'
          }
        },
        normal: {
          'guide-perspective': {
            boxShadow: 'none'
          },
          'guide-perspective-inner': {
            border: '1px solid #04a6e9'
          }
        },
        none: {
          'guide-perspective': {
            boxShadow: 'none'
          },
          'guide-perspective-inner': {
            border: 'none'
          }
        }
      },
      {
        emphasized: config.theme === 'emphasized',
        normal: config.theme === 'normal',
        none: config.theme === 'none'
      }
    )
    return (
      <div style={StepStyles['guide-perspective']}>
        <div style={StepStyles['guide-perspective-inner']} />
      </div>
    )
  }
}
