import React from 'react'
import { notification, Button } from 'antd'
import { action } from 'mobx'
import store from 'wp/store'
import { getLocalStorage } from 'wp/utils/helper'
import { getJson } from 'wp/api'
import hookStore from 'wp/store/hook'

const { WPSceneStore } = store

const initPage = () => {
  return new Promise(resolve => {
    const { init } = WPSceneStore
    const pageId = getLocalStorage('pageId')
    WPSceneStore.pageId && (WPSceneStore.pageId = pageId)
    if (pageId) {
      getJson(pageId).then(res => {
        try {
          if (res.code === 0) {
            const { page, elements } = JSON.parse(res.data.pageJson)
            // 组装适用于管理端的数据结构
            const itemList = elements.map(item => {
              return {
                widgetType: item.type,
                targetId: item.id,
                [item.type]: item
              }
            })
            action(init)(page, itemList)
            // onInit钩子调用
            hookStore.walkHooks('onInit', { page })
            resolve()
          } else {
            resolve()
          }
        } catch (e) {
          resolve(e)
        }
      })
    }
    resolve()
  })
}

const confirm = function() {
  return initPage()
}
const close = function() {}

export default function CacheNotify() {
  const key = Date.now()
  const pageId = getLocalStorage('pageId')
  if (pageId) {
    notification.open({
      message: null,
      description: '继续上一次已保存的编辑？',
      btn: (
        <Button
          type="primary"
          size="small"
          onClick={() => {
            confirm().then(() => {
              notification.close(key)
            })
          }}
        >
          好的
        </Button>
      ),
      key,
      onClose: close
    })
  }
}
