import React from 'react'
import { Checkbox, Tooltip, Icon } from 'antd'

export default function({ value, onChange, style = {} }) {
  return (
    <Checkbox style={style} checked={Boolean(value)} onChange={onChange}>
      微信下载
      <Tooltip
        placement="topRight"
        arrowPointAtCenter
        title={
          <div style={{ fontSize: 12 }}>
            勾选后，当用户点击下载按钮时，调起自带浏览器进行下载，使下载类广告可以在微信安卓流量投放。
          </div>
        }
        overlayClassName="WXDTooltip"
      >
        <Icon type="question-circle" style={{ marginLeft: 10 }} />
      </Tooltip>
    </Checkbox>
  )
}
