import React, { Component } from 'react'
import { inject, observer } from 'mobx-react'
import { action } from 'mobx'
import BasicAttrs from './basic-attrs'
import WidgetName from './widget-name'
import FixedAttr from './fixed-attr'
import Jump from './jump'
import store from 'wp/store'
import sceneMapping, { POPUP } from 'wp/utils/sceneType'

export default function editorWrapper({ type, basic = {} }) {
  return function EditorDecorator(Inner) {
    @inject('WPSceneStore')
    @observer
    class Editor extends Component {
      handleChange = (changed = {}) => {
        action(this.getCurrentSceneStore().changeItemProps)(changed)
      }
      getCurrentSceneStore = () => {
        return store[sceneMapping[store.WPSwitch.currentScene]]
      }
      render() {
        const target = this.props[type]
        return (
          <Inner
            handleChange={this.handleChange}
            target={target}
            BasicAttrsCom={
              <BasicAttrs
                target={target}
                basic={basic}
                handleChange={this.handleChange}
              />
            }
            BasicAttrsComponent={props => {
              return (
                <BasicAttrs
                  target={target}
                  basic={basic}
                  handleChange={this.handleChange}
                  {...props}
                />
              )
            }}
            WidgetNameCom={
              <WidgetName target={target} handleChange={this.handleChange} />
            }
            FixedAttrCom={
              <FixedAttr target={target} handleChange={this.handleChange} />
            }
            JumpCom={
              <Jump
                target={target}
                handleChange={this.handleChange}
                option={{
                  ...basic.jump,
                  nonPopup:
                    basic.jump && basic.jump.nonPopup
                      ? store.WPSwitch.currentScene === POPUP ||
                        basic.jump.force
                        ? 1
                        : 0
                      : 0
                }}
              />
            }
          />
        )
      }
    }

    return Editor
  }
}
