import React, { Component } from 'react'
import { Form, Select } from 'antd'
import { formItemProps } from './helper'
import { observer } from 'mobx-react'

const FormItem = Form.Item
const Option = Select.Option

@observer
export default class FixedAttr extends Component {
  render() {
    const { target, handleChange } = this.props
    return (
      <React.Fragment>
        <FormItem label="固定位置" {...formItemProps}>
          <Select
            value={target.fixed}
            onChange={value => handleChange({ fixed: value })}
          >
            <Option value={1}>是</Option>
            <Option value={0}>否</Option>
          </Select>
        </FormItem>
      </React.Fragment>
    )
  }
}
