import React from 'react'
import Style from '../../index.less'
import Common from 'pro/lib/common'
import { inject, observer } from 'mobx-react'
import { Input, Modal } from 'antd'

export default inject('mediaStore')(
  observer(function TagItem(props: any) {
    const inputText = React.createRef()
    function onClick(fn, clickedTags, id, isMedia, sortMode) {
      if (sortMode && !isMedia) {
        return Common.handleWarn('标签移动状态，不支持修改标签')
      }
      fn([clickedTags.includes(id) || isMedia ? null : id])
    }
    function editTag(inputRef, outerProps) {
      const { parentTag } = props
      const text = inputRef.current.input.value
      console.log(text)
      if (!text) {
        Common.handleWarn('不能为空')
        return
      }

      if (text.length > 20) {
        Common.handleWarn('不能超过20个字')
        return
      }
      const {
        content: { id },
        mediaStore: { updateTag }
      } = outerProps
      updateTag(id, text, parentTag)
    }
    function deleteTag(outerProps) {
      const {
        content: { id },
        hasLeaf,
        mediaStore: { fetchTags }
      } = outerProps
      Modal.confirm({
        title: '提示',
        content: hasLeaf
          ? '删除此标签，其子集标签和媒体关联将全部清除'
          : '删除此标签，其媒体关联将全部清除',
        onOk() {
          const action = hasLeaf
            ? '/mediatag/deleteTag1'
            : '/mediatag/deleteTag2'
          Common.newFetch({
            url: action,
            method: 'post',
            postWithQuery: true,
            params: { tagId: id }
          }).then(res => {
            switch (res['code']) {
              case '0':
                Common.handleSuccess('删除标签成功')
                fetchTags()
                break
              default:
                Common.handleError(res['desc'])
            }
          })
        },
        okText: '确定',
        cancelText: '取消'
      })
    }
    const {
      content: { tagName, id },
      mediaStore: {
        clickedTags,
        editTags,
        updateClickedTags,
        updateEditTags,
        highlightTags,
        sortMode
      },
      isMedia,
      className,
      cursor
    } = props
    return (
      <div
        className={`${Style.tagItem} ${
          cursor ? Style.sortMode : ''
        } ${className}`}
      >
        {editTags.includes(id) ? (
          <div>
            <Input
              style={{ width: 120 }}
              size="small"
              ref={inputText}
              defaultValue={tagName}
            />{' '}
            <a className="ml5" onClick={editTag.bind(null, inputText, props)}>
              保存
            </a>
            <a className="ml5" onClick={() => updateEditTags([])}>
              取消
            </a>
          </div>
        ) : (
          <div>
            <span
              className={highlightTags.includes(id) ? Style.selected : null}
              onClick={onClick.bind(
                this,
                updateClickedTags,
                clickedTags,
                id,
                isMedia,
                sortMode
              )}
            >
              {tagName}
            </span>
            {clickedTags.includes(id) ? (
              <React.Fragment>
                <a className="ml5" onClick={updateEditTags.bind(this, [id])}>
                  修改
                </a>
                {/* <a className="ml5" onClick={() => deleteTag(props)}>
                  删除
                </a> */}
              </React.Fragment>
            ) : null}
          </div>
        )}
      </div>
    )
  })
)
