import React from 'react'
import TagItem from '../tagItem/index'
import Style from '../../index.less'
import Add from '../Add/index'
import { inject, observer } from 'mobx-react'
import { DndProvider, DragSource, DropTarget } from 'react-dnd'
import HTML5Backend from 'react-dnd-html5-backend'
import UPDATE from 'immutability-helper'
import TagTypes from '../../constant/tagType'
let dragingIndex = -1
let sourceParentTagId = -1
function moveRow(Store, parentTag, dragIndex, hoverIndex) {
  console.log(parentTag, dragIndex, hoverIndex)
  const { updateSort, allTags } = Store
  // 修改了第三级顺序的情况
  // 处理发生变化的这一层
  const originalTagIds = parentTag.children.map(({ id }) => id)
  const Item = originalTagIds[dragIndex]
  // 处理整棵树 (目前只支持拖动活动标签)
  const FirstLevel = allTags.find((item) => item.id === parentTag.parentId)
  const FirstIndex = allTags.findIndex((item) => item.id === parentTag.parentId)
  const SecondIndex = FirstLevel.children
    ? FirstLevel.children.findIndex((item) => item.id === parentTag.id)
    : -1
  const ObjectItem = parentTag.children[dragIndex]
  updateSort(
    UPDATE(allTags, {
      [FirstIndex]: {
        children: {
          [SecondIndex]: {
            children: {
              $splice: [
                [dragIndex, 1],
                [hoverIndex, 0, ObjectItem]
              ]
            }
          }
        }
      }
    }),
    {
      id: parentTag.id,
      children: UPDATE(originalTagIds, {
        $splice: [
          [dragIndex, 1],
          [hoverIndex, 0, Item]
        ]
      })
    }
  )
}
function DragTag(props) {
  const {
    connectDragSource,
    connectDropTarget,
    isOver,
    content,
    isMedia,
    ...restProps
  } = props
  let className = ''

  if (isOver) {
    if (content.parentId !== sourceParentTagId) {
      className += Style.error
    }
    if (content.parentId === sourceParentTagId) {
      // 只允许同层级之间的顺序移动
      if (restProps.index > dragingIndex) {
        className += Style.backward
        console.log('backward')
      }
      if (restProps.index < dragingIndex) {
        console.log('forward')
        className += Style.forward
      }
    }
  }

  return connectDragSource(
    connectDropTarget(
      <div>
        <TagItem
          cursor
          className={className}
          content={content}
          hasLeaf={false}
          isMedia={isMedia}
        />
      </div>
    )
  )
}
const Source = {
  beginDrag(props) {
    console.log(props)
    sourceParentTagId = props.content.parentId
    dragingIndex = props.index
    return {
      index: props.index
    }
  }
}
const Target = {
  drop(props, monitor) {
    const dragIndex = monitor.getItem().index
    const hoverIndex = props.index
    if (dragIndex === hoverIndex || props.content.parentId !== sourceParentTagId) {
      return
    }
    console.log('second ', dragIndex, hoverIndex)
    props.moveRow(dragIndex, hoverIndex)
    monitor.getItem().index = hoverIndex
  }
}
const DragableTag = DropTarget('column', Target, (connect, monitor) => ({
  connectDropTarget: connect.dropTarget(),
  isOver: monitor.isOver()
}))(
  DragSource('column', Source, (connect) => ({
    connectDragSource: connect.dragSource()
  }))(DragTag)
)

export default inject('mediaStore')(
  observer(function Second(props: any) {
    const {
      tag,
      isMedia,
      className,
      cursor,
      mediaStore: { allTags, sortMode }
    } = props
    return (
      <div
        className={`${Style.borderBottom} ${className} ${
          cursor ? Style.move : ''
        }`}
      >
        <div className={Style.leftTag}>
          <TagItem cursor={cursor} content={tag} hasLeaf isMedia={isMedia} parentTag={tag}/>
        </div>

        <div className={Style.rightTag}>
          {TagTypes.includes(
            allTags.find((item) => item.id === tag.parentId).tagName
          ) && sortMode ? (
            <DndProvider backend={HTML5Backend}>
              {tag.children &&
                tag.children.map((item, index) => {
                  return (
                    <DragableTag
                      key={item.id}
                      index={index}
                      moveRow={moveRow.bind(null, props.mediaStore, tag)}
                      content={item}
                      isMedia={isMedia}
                    />
                  )
                })}
            </DndProvider>
          ) : (
            tag.children &&
            tag.children.map((item) => {
              return (
                <TagItem
                  key={item.id}
                  content={item}
                  hasLeaf={false}
                  isMedia={isMedia}
                  parentTag={tag}
                />
              )
            })
          )}
          {!sortMode && (
            <Add className={Style.tagItem} parentTag={tag} currentLevel={2} />
          )}
        </div>
      </div>
    )
  })
)
