import React, { Component } from 'react'
import QRCode from 'qrcode.react'
import styles from './index.less'
import { staticResourcePrefix, h5RenderEndpoint } from 'wp/config'
import Utils from 'pro/lib/utils'
import StatisticStore from '../store'
import { observer } from 'mobx-react'
import { hashHistory } from 'react-router'

@observer
export default class PagePreview extends Component {
  handleToHome() {
    hashHistory.push('/home')
  }
  render() {
    let landId = Utils.getUrlParams('landId')
    const url = `${h5RenderEndpoint}?id=${landId}`
    return (
      <div className={styles['wrapper']}>
        <div className={styles['nav']}>
          <div className={styles['return-btn']} onClick={this.handleToHome}>
            <img src={`${staticResourcePrefix}/logo.png`} />
            <span>返回首页</span>
          </div>
          <div className={styles['divider']} />
          <div className={styles['title']}>数据-{StatisticStore.landName}</div>
        </div>
        <div className={styles['phone']}>
          <div className={styles['header']} />
          <div className={styles['body']}>
            <iframe src={`/render?id=${landId}`} frameBorder="0" style={{ width: 320, height: 515 }} />
          </div>
          <div className={styles['footer']} />
        </div>
        <div className={styles['qrcode']}>
          <QRCode value={url} size={160} />
        </div>
        <div className={styles['text1']}>手机扫描二维码预览</div>
        <div className={styles['text2']}>
          <span>你也可以打开</span>
          <a href={url} target="_blank">
            新窗口预览
          </a>
        </div>
      </div>
    )
  }
}
