import React, { Component } from 'react'
import { DatePicker, Icon, Dropdown, Menu } from 'antd'
import moment from 'moment'
import styles from './extra-content.less'
import PubSub from 'pubsub-js'
import { FormDataConditionEvent } from '../../config/pbTopics'
import StatisticStore from '../../store'
import { observer } from 'mobx-react'
import { exportFormData } from '../../api'
import { FormDataTableOptions } from '../../config'

const { RangePicker } = DatePicker

@observer
export default class FormOptions extends Component {
  state = {
    selectedFormId: 0,
    startDate: moment(FormDataTableOptions.defaultRangeValue[0]).format(
      'YYYY-MM-DD'
    ),
    endDate: moment(FormDataTableOptions.defaultRangeValue[1])
      .add(1, 'days')
      .format('YYYY-MM-DD')
  }
  onTimeChange = (_, dateString) => {
    // 给后端加的逻辑
    if (dateString[1]) {
      dateString[1] = moment(dateString[1])
        .add(1, 'days')
        .format('YYYY-M-D')
    }
    this.setState(
      {
        startDate: dateString[0] || undefined,
        endDate: dateString[1] || undefined
      },
      this.publishEvent
    )
  }
  publishEvent = () => {
    const { startDate, endDate, selectedFormId } = this.state
    PubSub.publish(FormDataConditionEvent, {
      startDate,
      endDate,
      form:
        StatisticStore.conditionForms.find(
          item => item.id === selectedFormId
        ) || {}
    })
  }
  onFormSelect = ({ item, key, keyPath }) => {
    this.setState(
      {
        selectedFormId: key
      },
      this.publishEvent
    )
  }
  componentDidMount() {
    // 默认选中全部表单
    this.onFormSelect({
      key: undefined
    })
  }
  handleClick = () => {
    const { landId, landName, conditionForms } = StatisticStore
    const { startDate, endDate, selectedFormId } = this.state
    const form = conditionForms.find(item => item.id === selectedFormId) || {}
    exportFormData({
      landId,
      landName,
      formName: form.name || '',
      formId: form.id || '',
      startDate,
      endDate
    })
  }
  render() {
    const { selectedFormId } = this.state
    const form =
      StatisticStore.conditionForms.find(item => item.id === selectedFormId) ||
      {}
    const formLabel = form.name
    return (
      <div className={styles['optionsWrapper']}>
        <Dropdown
          overlay={
            <Menu onClick={this.onFormSelect}>
              <Menu.Item key={undefined}>全部表单</Menu.Item>
              {StatisticStore.conditionForms.map(item => {
                return <Menu.Item key={item.id}>{item.name}</Menu.Item>
              })}
            </Menu>
          }
          trigger={['click']}
        >
          <div style={{ cursor: 'pointer' }}>
            {formLabel || '表单筛选'} <Icon type="down" />
          </div>
        </Dropdown>
        <RangePicker
          style={{ width: 220, marginLeft: 18 }}
          ranges={{
            最近一天: [moment(), moment()],
            最近七天: [moment().subtract(6, 'days'), moment()],
            最近一月: [moment().subtract(1, 'months'), moment()],
            最近三月: [moment().subtract(3, 'months'), moment()]
          }}
          onChange={this.onTimeChange}
          allowClear={false}
          defaultValue={FormDataTableOptions.defaultRangeValue}
        />
        <div className={styles['divider']} />
        <div className={styles['exporter']} onClick={this.handleClick}>
          <i className="tuiafont icon-cur-export" />
          <span>导出</span>
        </div>
      </div>
    )
  }
}
