import React, { Component } from 'react'
import { DatePicker } from 'antd'
import moment from 'moment'
import styles from './extra-content.less'
import PubSub from 'pubsub-js'
import { BIDataConditionsEvent, BIDataExportEvent } from '../../config/pbTopics'
import { BIDataTableOptions } from '../../config'

const { RangePicker } = DatePicker

let { defaultRangeValue } = BIDataTableOptions

export default class BIExtraContent extends Component {
  state = {
    startDate: undefined,
    endDate: undefined
  }
  onTimeChange = (_, dateString) => {
    // 因为后端查库需要加的逻辑
    if (dateString[1]) {
      dateString[1] = moment(dateString[1])
        .add(1, 'days')
        .format('YYYY-M-D')
    }
    this.setState({
      startDate: dateString[0] || undefined,
      endDate: dateString[1] || undefined
    }, this.publishEvent)
  }
  publishEvent = () => {
    const { startDate, endDate } = this.state
    PubSub.publish(BIDataConditionsEvent, {
      startDate,
      endDate,
      _dataToFetch: ['chart', 'table']
    })
  }
  handleClick = () => {
    PubSub.publish(BIDataExportEvent)
  }
  render() {
    return (
      <div className={styles['optionsWrapper']}>
        <RangePicker
          style={{ width: 220, marginLeft: 18 }}
          ranges={{
            最近一天: [moment(), moment()],
            最近七天: [moment().subtract(6, 'days'), moment()],
            最近一月: [moment().subtract(1, 'months'), moment()],
            最近三月: [moment().subtract(3, 'months'), moment()]
          }}
          onChange={this.onTimeChange}
          allowClear={false}
          defaultValue={defaultRangeValue}
        />
        <div className={styles['divider']} />
        <div className={styles['exporter']} onClick={this.handleClick}>
          <i className="tuiafont icon-cur-export" />
          <span>导出</span>
        </div>
      </div>
    )
  }
}
