import React, { Component } from 'react'
import Header from './header'
import Search from './search'
import ListMode from './body/list-mode'
import CardMode from './body/card-mode'
import styles from './index.less'
import { BackTop, Spin } from 'antd'
import { hot } from 'react-hot-loader'
import { staticResourcePrefix } from 'wp/config'
import { getPages, getAllTags } from './api'
import NoData from './components/noData'

class Index extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      mode: 'list',
      loading: false,
      firstLoaded: false,
      condition: {
        title: '',
        // state: 0,
        // advertTradId: '',
        startDate: '',
        endDate: '',
        id: '',
        currentPage: 1,
        pageSize: 10
      },
      data: {},
      listData: [],
      total: 0,
      tags: [],
      tagsMap: {}
    }
  }
  componentDidMount() {
    this.handleChange()
    this.getTags()
  }
  getTags() {
    getAllTags().then(res => {
      const firstLevel = res.data
      const secondLevel = firstLevel.reduce(
        (a, b) => a.concat(b.children || []),
        []
      )
      const thirdLevel = secondLevel.reduce(
        (a, b) => a.concat(b.children || []),
        []
      )

      let tagOptions = firstLevel.concat(secondLevel, thirdLevel)
      let tagsMap = tagOptions.reduce((acc, tag) => {
        acc[tag.tagNum] = tag
        return acc
      }, {})
      this.setState({
        tags: res.data,
        tagsMap
      })
    })
  }
  _getPages() {
    return getPages(this.state.condition).then(res => {
      this.setState({
        listData: res.data.list,
        total: res.data.totalCount,
        loading: false,
        firstLoaded: true
      })
    })
  }
  handleChange = (changed = {}) => {
    this.setState(
      {
        condition: Object.assign({}, this.state.condition, changed),
        loading: true
      },
      this._getPages
    )
  }
  render() {
    const {
      mode,
      condition,
      listData,
      loading,
      total,
      firstLoaded,
      tags,
      tagsMap
    } = this.state
    return (
      <div className={styles['container']}>
        <Header />
        <Search
          tags={tags}
          condition={condition}
          handleChange={this.handleChange}
        />
        <Spin
          spinning={loading}
          indicator={
            <img
              style={{ width: 100, height: 100 }}
              src={`${staticResourcePrefix}/jimu_loading_new.gif`}
            />
          }
        >
          {!firstLoaded ? (
            <div style={{ height: 500 }} />
          ) : listData.length === 0 ? (
            <NoData />
          ) : mode === 'list' ? (
            <ListMode
              listData={listData}
              total={total}
              current={condition.currentPage}
              onChange={this.handleChange}
              tagsMap={tagsMap}
            />
          ) : (
            <CardMode
              listData={listData}
              total={total}
              current={condition.currentPage}
            />
          )}
        </Spin>
        <BackTop />
      </div>
    )
  }
}

export default hot(module)(Index)
