import React, { Component } from 'react'
import { staticResourcePrefix } from 'wp/config'
import styles from './index.less'
// import TuiaIcon from 'wp/constructors/fc/icon'
import { getLocalStorage } from 'wp/utils/helper'

export default class Header extends Component {
  render() {
    let lastName = '客'
    try {
      let nickname = getLocalStorage('nickname')
      nickname && (lastName = nickname[nickname.length - 1])
    } catch (e) {
      console.log(e)
    }
    return (
      <div className={styles['header-wrapper']}>
        <a className={styles['first']} href='/basics#/'>
          <img src={`${staticResourcePrefix}/logo_entire.png`} />
        </a>
        <div className={styles['last']}>
          <div className={styles['header-img']}>{lastName}</div>
          {/* <div className={styles['divider']} />
          <TuiaIcon type="icon-nav_signout" /> */}
        </div>
      </div>
    )
  }
}
