import React, { Component } from 'react'
import { List, message, Button, Modal, Select, Spin, Tag } from 'antd'
import styles from './index.less'
import {
  deleteByLandPageId,
  searchUserByName,
  permissionSave,
  listPermission
} from '../api'
import TuiaIcon from 'wp/constructors/fc/icon'
import PreviewH5 from 'components/preview-h5'
import RelateAd from 'pro/components/relate-ad'
import { jumpIntoWorkplace } from 'wp/utils/util'
import { CopyToClipboard } from 'react-copy-to-clipboard'
import { hashHistory } from 'react-router'
import { debounce } from 'lodash-es'
const { confirm } = Modal
const { Option } = Select

// const stateFilter = state => {
//   switch (state) {
//     default:
//     case 0:
//       return '未审核'
//   }
// }

export default class ListMode extends Component {
  constructor(props) {
    super(props)
    this.fetchUser = debounce(this.fetchUser, 800)
  }
  state = {
    visible: false,
    currentId: null,
    fetching: false,
    data: [],
    value: []
  }
  edit(pageId) {
    jumpIntoWorkplace(pageId)
  }
  copy(pageId) {
    jumpIntoWorkplace(pageId, true)
  }
  handlePreviewData(pageId) {
    hashHistory.push(`statistic?landId=${pageId}`)
  }
  delete = id => {
    confirm({
      title: '确认删除么',
      content: '点击确认将删除',
      onOk: () => {
        deleteByLandPageId(id).then(res => {
          message.success('删除成功')
          this.props.onChange()
        })
      }
    })
  }
  addTeamWork = id => {
    listPermission(id).then(res => {
      const { data } = res
      const value = (data || []).map(item => item.adminId)
      this.setState({
        visible: true,
        currentId: id,
        value,
        data
      })
    })
  }
  cancel = () => {
    this.setState({
      visible: false,
      currentId: null,
      fetching: false,
      data: [],
      value: []
    })
  }
  fetchUser = value => {
    this.setState({ data: [], fetching: true })
    searchUserByName(value).then(res => {
      const { data } = res
      this.setState({
        data,
        fetching: false
      })
    })
  }
  handleChange = value => {
    this.setState({
      value,
      fetching: false
    })
  }
  addUser = () => {
    const { currentId, value } = this.state
    permissionSave(currentId, value).then(res => {
      message.success('添加成功')
      this.setState({
        visible: false,
        currentId: null,
        fetching: false,
        data: [],
        value: []
      })
    })
  }
  render() {
    const { listData, total, current, tagsMap } = this.props
    const { visible, value, fetching, data } = this.state
    return (
      <div className={styles['container']}>
        {visible && (
          <Modal
            title="加入协作"
            // eslint-disable-next-line react/jsx-boolean-value
            visible={true}
            onOk={this.addUser}
            onCancel={this.cancel}
          >
            <Select
              mode="multiple"
              value={value}
              placeholder="请输入加入协作人的姓名"
              notFoundContent={fetching ? <Spin size="small" /> : null}
              filterOption={false}
              onSearch={this.fetchUser}
              onChange={this.handleChange}
              style={{ width: '100%' }}
            >
              {data.map(d => (
                <Option key={d.adminId} value={d.adminId}>
                  {d.adminName}
                </Option>
              ))}
            </Select>
          </Modal>
        )}
        <List
          className="homepage-list"
          itemLayout="vertical"
          size="large"
          pagination={{
            onChange: page => {
              this.props.onChange({
                currentPage: page
              })
            },
            showTotal: (total, page) => {
              return `${page} / ${total}`
            },
            pageSize: 10,
            showQuickJumper: true,
            size: 'large',
            total,
            current: current || 1
          }}
          dataSource={listData}
          renderItem={item => (
            <List.Item key={item.title}>
              <div className={styles['item']}>
                <div
                  className={styles['img']}
                  style={{ backgroundImage: `url("${item.thumbnailUrl}")` }}
                />
                <div className={styles['main']}>
                  <div className={styles['top']}>
                    <span className={styles['id']}>
                      ID:
                      {item.id}
                    </span>
                    {item.createrName && (
                      <div className={styles['author']}>
                        <TuiaIcon type="icon-system_founder" />
                        {item.createrName}
                      </div>
                    )}
                  </div>
                  <div className={styles['middle']}>
                    <div>{item.name}</div>
                    {/* <div>
                      <Tooltip
                        placement="top"
                        arrowPointAtCenter
                        title="拒绝理由：广告计划被拒绝，请重新提交广告计划。"
                      >
                        <div className={styles['ball']} />
                      </Tooltip>
                      {stateFilter(item.state)}
                    </div> */}
                  </div>
                  <div className={styles['bottom']}>
                    {item.promoteTag &&
                      item.promoteTag.split(',').map(tagNum => {
                        let tag = tagsMap[tagNum]

                        return (
                          tag && (
                            <Tag
                              key={tag.id}
                              color="cyan"
                              style={{ marginBottom: 5 }}
                            >
                              {tag.tagName}
                            </Tag>
                          )
                        )
                      })}
                  </div>
                </div>
                <div className={styles['control-bar']}>
                  <div onClick={this.edit.bind(this, item.id)}>编辑</div>
                  <PreviewH5
                    id={item.id}
                    title={item.title}
                    url={location.origin + `/render?id=${item.id}`}
                    content={({ show }) => <div onClick={show}>预览</div>}
                  />
                  <div onClick={this.copy.bind(this, item.id)}>复制页面</div>
                  <RelateAd
                    pageId={item.id}
                    content={({ show }) => <div onClick={show}>关联广告</div>}
                  />
                  <CopyToClipboard
                    text={item.link}
                    onCopy={() => message.success('复制成功')}
                  >
                    <div>复制链接</div>
                  </CopyToClipboard>
                  <div onClick={() => this.delete(item.id)}>删除</div>
                  {/* <div>跳转链接</div> */}
                  <div onClick={() => this.addTeamWork(item.id)}>加入协作</div>
                  <Button
                    size="small"
                    type="primary"
                    style={{
                      width: 80,
                      fontSize: 12,
                      lineHeight: '24px',
                      borderRadius: 4
                    }}
                    onClick={this.handlePreviewData.bind(this, item.id)}
                  >
                    查看数据
                  </Button>
                </div>
              </div>
            </List.Item>
          )}
        />
      </div>
    )
  }
}
