import common from 'pro/lib/common'

const prefix = '/java/land'

export const getConditions = () => {
  return common.fetch(`${prefix}/conditions`, {}, 'get')
}

export const getPages = condition => {
  return common.fetch(`${prefix}/selectLoads`, { ...condition }, 'post', {
    isJson: true
  })
}

export const getAds = condition => {
  return common.fetch(`/java/advert/selectAdvertList`, { ...condition }, 'get')
}

export const saveAdAndPageRelations = condition => {
  return common.fetch(`${prefix}/landMappingAdvert`, { ...condition }, 'post', {
    isJson: true
  })
}

export const deleteByLandPageId = id => {
  return common.fetch(`/java/land/delete`, { id }, 'post', {
    isLoading: true
  })
}

export const searchUserByName = name => {
  return common.fetch(`/java/admin/name/match`, { name }, 'get')
}

export const permissionSave = (landPageId, adminId) => {
  return common.fetch(
    `/java/permission/save`,
    { landId: landPageId, adminId, scene: 0 },
    'post'
  )
}

export const listPermission = landPageId => {
  return common.fetch(
    `/java/land/listPermission`,
    { landId: landPageId },
    'get',
    {
      isLoading: true
    }
  )
}
export const getAllTags = landPageId => {
  return common.fetch(`/java/tag/getAllTags`)
}
