import React, { Component } from 'react'
import { Modal, Icon } from 'antd'
import TuiaIcon from 'wp/constructors/fc/icon'
import cn from 'classnames'
import styles from './index.less'
import JMInput2 from 'pro/components/jm-input-2'
import { hashHistory } from 'react-router'
import { sceneGen } from 'wp/constructors/other-default'
import { removeLocalStorage, setLocalStorage } from 'wp/utils/helper'

// const { Option } = Select

export default class Preview extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      scene: sceneGen(),
      label: {
        id: 1
      },
      hotLabels: [
        {
          name: '金融投资'
        },
        {
          name: '旅游宣传'
        },
        {
          name: '女性时尚'
        },
        {
          name: '艺术培训教育'
        }
      ]
    }
  }
  show = () => {
    this.setState({
      modalVisible: true
    })
  }
  cancel = () => {
    this.setState({
      modalVisible: false
    })
  }
  changeWidth = (width, height = 603) => {
    this.setState({
      scene: Object.assign({}, this.state.scene, {
        width: width + 'px',
        height: height + 'px'
      })
    })
  }
  handleChangeProp = (key, value) => {
    this.setState({
      scene: Object.assign({}, this.state.scene, {
        [key]: value
      })
    })
  }
  handleSelect = value => {
    this.setState({
      label: {
        id: value
      }
    })
  }
  handleConfirm = () => {
    removeLocalStorage('pageId')
    // const timer = setTimeout(() => {
    //   store.WPHookStore.walkHooks('onSceneInnerWidthChangeEnd', {
    //     width: getNumber(this.state.scene.width)
    //   })
    //   store.WPSceneStore.init(this.state.scene)
    //   clearTimeout(timer)
    // }, 100)
    // 通过localStorage做组件通信
    setLocalStorage('createScene', this.state.scene)
    hashHistory.push('/workplace')
  }
  render() {
    const { width, name, title } = this.state.scene
    const { label } = this.state
    const { onCancel, content } = this.props
    const TriggerIns = content({
      show: this.show
    })
    const isCompleted = Boolean(width && name && title && label.id)
    return (
      <React.Fragment>
        {TriggerIns}
        <Modal
          width={633}
          title={
            <div
              style={{
                display: 'flex',
                justifyContent: 'space-between',
                alignItems: 'center',
                height: '100%'
              }}
            >
              新建站点
              <Icon
                type="close"
                onClick={this.cancel}
                style={{ cursor: 'pointer' }}
              />
            </div>
          }
          footer={null}
          visible={this.state.modalVisible}
          wrapClassName="newSiteModal"
          onCancel={onCancel}
          closable={false}
          destroyOnClose
          mask={false}
        >
          <div className={styles['wrapper']}>
            <div className={styles['left']}>
              <div className={styles['title']}>您的设计稿尺寸</div>
              <div>
                <div
                  className={cn(styles['mobile-model'], {
                    [styles['active']]: width === '320px'
                  })}
                  onClick={this.changeWidth.bind(this, 320, 603)}
                >
                  <TuiaIcon type="icon-system_phone" />
                  <div>iPhone 5/5c/5s</div>
                  <div>640x1136 px</div>
                </div>
                <div
                  className={cn(styles['mobile-model'], {
                    [styles['active']]: width === '375px'
                  })}
                  onClick={this.changeWidth.bind(this, 375, 734)}
                >
                  <TuiaIcon type="icon-system_phone1" />
                  <div>iPhone X</div>
                  <div>750x1624 px</div>
                </div>
              </div>
            </div>
            <div className={styles['gutter']} />
            <div className={styles['right']}>
              <JMInput2
                value={name}
                onChange={e => this.handleChangeProp('name', e.target.value)}
                label="页面名称"
                placeholder="必填，不能超过15个字符"
                maxLength={15}
                autoFocus
              />
              <div style={{ height: 7 }} />
              <JMInput2
                value={title}
                onChange={e => this.handleChangeProp('title', e.target.value)}
                label="网页标题"
                placeholder="必填，不能超过15个字符"
                maxLength={15}
              />
              {/* <div className={styles['all-labels']}>
                <div className={styles['name']}>行业标签</div>
                <Select
                  value={label.id}
                  placeholder="非必填，选择行业标签"
                  style={{ width: '100%' }}
                  onSelect={value => this.handleSelect(value)}
                >
                  <Option value={1}>贷款</Option>
                  <Option value={2}>信用卡</Option>
                  <Option value={3}>保险</Option>
                  <Option value={4}>p2p</Option>
                </Select>
              </div>
              <div className={styles['hot-labels']}>
                <div className={styles['name']}>热门标签</div>
                <div className={styles['labels-wrapper']}>
                  {this.state.hotLabels.map((item, idx) => {
                    return (
                      <div className={styles['item']} key={idx}>
                        #{item.name}#
                      </div>
                    )
                  })}
                </div>
              </div> */}
            </div>
            <div className={styles['btns']}>
              <div
                className={cn(styles['cancel'], styles['button'])}
                onClick={this.cancel}
              >
                取消
              </div>
              <div
                className={cn(styles['confirm'], styles['button'], {
                  [styles['btn-active']]: isCompleted
                })}
                onClick={isCompleted ? this.handleConfirm : undefined}
              >
                创建
              </div>
            </div>
          </div>
        </Modal>
      </React.Fragment>
    )
  }
}
