import React, { Component } from 'react'
import { Link } from 'react-router'
import { Breadcrumb } from 'antd'

import style from './index.less'

export default class breadcrumb extends Component {
  itemRender (route, params, routes, paths) {
    const last = routes.indexOf(route) === routes.length - 1
    return last ? (route.breadcrumbName ? <span>{route.breadcrumbName}</span> : null) : (route.breadcrumbName ? <Link to={paths.join('/') || '/'}>{route.breadcrumbName}</Link> : null)
  }
  render () {
    let { routes } = this.props
    routes = routes.filter(el => el.path)
    return (
      <Breadcrumb className={style.breadcrumb} itemRender={this.itemRender} routes={routes} />
    )
  }
};
