const util = {
  copy: function (target, source) {
    var newObj = Object.assign({}, target)
    for (let x in source) {
      if (util.checkType(source[x])) {
        newObj[x] = util.copy(newObj[x], source[x])
      } else {
        newObj[x] = source[x]
      }
    }
    return newObj
  },

  checkType: function (o, type) {
    return Object.prototype.toString.call(o) === '[object ' + (type || 'Object') + ']'
  },

  filterNull: (obj) => {
    if (!util.checkType(obj, 'Object')) return obj
    let source = Object.assign({}, obj)

    for (var i in source) {
      if (!source[i]) delete source[i]
      if (util.checkType(source[i])) {
        return util.filterNull(source[i])
      }
    }

    return source
  },

  // 复制剪切板
  copyToClipboard: str => {
    const el = document.createElement('textarea')
    el.value = str
    document.body.appendChild(el)
    el.select()
    document.execCommand('copy')
    document.body.removeChild(el)
  },

  // 获取qs中指定参数
  get: (name) => {
    var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i')
    var r = window.location.search.substr(1).match(reg)
    if (r != null) return unescape(r[2])
    return null
  },

  // 对象中参数为对象或数组，则序列化
  serialize: (source) => {
    if (!util.checkType(source)) {
      return source
    }

    let target = Object.assign({}, source)

    for (var i in target) {
      if (util.checkType(target[i]) || util.checkType(target[i], 'Array')) {
        target[i] = JSON.stringify(target[i])
      }
    }

    return target
  },

  // 删除指定id的数据
  deleteById: (source, index) => {
    if (!util.checkType(source, 'Array')) {
      return source
    }

    return source.splice(index, 1)
  }
}

export default util
