const webpack = require('webpack')
const merge = require('webpack-merge')
const webpackBaseConfig = require('./webpack.base.js')
const { getEntry, getStyle } = require('./webpack.util')

module.exports = merge(webpackBaseConfig, {
  mode: 'development',
  entry: getEntry(true),
  devtool: 'inline-source-map',
  module: {
    rules: [].concat(getStyle(true))
  },
  devServer: {
    contentBase: '../dist',
    hot: true
  },
  output: {
    publicPath: '/',
    filename: 'assets/[hash:8].[name].js',
    chunkFilename: 'assets/[contenthash:8].[name].js'
  },
  plugins: [
    new webpack.HotModuleReplacementPlugin(),
    new webpack.DefinePlugin({
      'process.env': {
        JIMU_ENV: `'${process.env.NODE_ENV}'`
      }
    })
  ]
})
