const CleanWebpackPlugin = require('clean-webpack-plugin')
const HtmlWebpackHarddiskPlugin = require('html-webpack-harddisk-plugin')
const path = require('path')
const { getHtmlWebpackPlugins } = require('./webpack.util')

module.exports = {
  entry: {},
  output: {
    path: path.join(__dirname, '../dist')
  },
  module: {
    rules: [
      // {
      //   test: /\.(js|jsx)$/,
      //   enforce: 'pre',
      //   loader: 'eslint-loader',
      //   options: {
      //     fix: true
      //   }
      // },
      {
        test: /\.(js|jsx)$/,
        loader: 'babel-loader',
        exclude: /node_modules/
      },
      {
        test: /\.(gif|jpg|png|woff|svg|eot|ttf)\??.*$/,
        loader: 'url-loader?limit=10240'
      },
      {
        test: /\.(html|tpl)$/,
        loader: 'html-loader'
      },
      {
        test: /\.ejs$/,
        loader: 'ejs-loader'
      }
    ]
  },
  resolve: {
    extensions: ['.js', '.jsx'],
    alias: {
      libs: path.join(__dirname, '../client/libs/'),
      basics: path.join(__dirname, '../client/pages/basics/'),
      pro: path.join(__dirname, '../client/pages/pro/'),
      wp: path.join(__dirname, '../client/pages/pro/containers/workplace'),
      assets: path.join(__dirname, '../client/assets/'),
      components: path.join(__dirname, '../client/components/'),
      render: path.join(__dirname, '../client/pages/pro/render/'),
      root: path.join(__dirname, '../'),
      layers: path.join(__dirname, '../client/pages/layers/'),
      layersWp: path.join(
        __dirname,
        '../client/pages/layers/containers/workplace'
      )
    }
  },
  externals: {
    swiper: 'Swiper'
  },
  plugins: [
    new CleanWebpackPlugin([path.resolve(__dirname, '../dist')], {
      root: path.resolve(__dirname, '../')
    }),
    ...getHtmlWebpackPlugins(),
    new HtmlWebpackHarddiskPlugin()
  ]
}
