var proxyMiddleware = require('http-proxy-middleware')

const filter = function(pathname, req) {
  return !(pathname.match('html') || pathname === '/')
}
function proxyAPI() {
  const ipReg = /^((?:(?:25[0-5]|2[0-4]\d|((1\d{2})|([1-9]?\d)))\.){3}(?:25[0-5]|2[0-4]\d|((1\d{2})|([1-9]?\d))))$/
  let target = process.env.proxy_api
  const ip = target.split(':')[0]
  target = ipReg.test(ip) || ip === 'localhost' ? `http://${target}` : target
  return proxyMiddleware(filter, {
    target,
    changeOrigin: true,
    headers: {
      referer: target
    }
  })
}

module.exports = {
  proxyAPI
}
