const path = require('path');

module.exports = appInfo => {
  const config = {};

  // use for cookie sign key, should change to your own and keep security
  // !不要使用用随机数
  // !生产环境部署一次之后请谨慎更改，因为更改之后由于key变化导致验证签名出错从而导致cookie（所有用户）失效
  config.keys = appInfo.name + '_1547113071224_997';

  // add your config here
  config.middleware = [];

  // sso
  // 如果新系统需要对接sso登录，请联系技术中台-刘瑶
  // !默认开启sso中间件校验。如需关闭则配置config.sso=false。
  config.sso = {
    // sso配置以及签名用
    ssourl: 'https://sso.duibadev.com.cn/',
    systemId: 214,
    systemName: 'tuia-jssdk-manage-node',
    appSecret: '6c3e8b5b11f95d94f4608006950dd7f6',
    profiles: 'dev',
    // 过滤接口，不走sso拦截器用
    filters: [ '/', '/favicon.ico', '/sso/ssoIndex', '/sso/findSsoHomeUrl', '/login', '/logout' ]
  };

  // jwt配置
  // !默认关闭jwt中间件校验。如需开启则配置如下
  // config.jwt = {
  //   secret: 'JWT_SECRET',
  //   exp: '1d',
  //   algorithm: 'HS256',
  //   // https://www.npmjs.com/package/minimatch
  //   // 如需过滤部分路由请修改filters。
  //   filters: [ '/', '/favicon.ico', '/sso/ssoIndex', '/sso/findSsoHomeUrl', '/login', '/logout' ]
  // };
  config.jwt = false;

  // 静态视图渲染配置
  config.view = {
    root: path.join(__dirname + '/../../client/dist/html'),
    mapping: {
      '.ejs': 'ejs',
      '.html': 'ejs'
    }
  };

  // 服务发现
  config.eureka = {
    services: []
  };

  // 服务代理中间件，另外可通过实现router接口实现反代。
  // 示例写法请参考@https://www.npmjs.com/package/@tuia/tuia-egg
  // 深入定制请参考https://www.npmjs.com/package/http-proxy-middleware
  config.proxy = false;

  // 默认使用file模式。如果熟悉nodejs stream API且没有其他业务参数时可使用stream模式。
  config.multipart = {
    mode: 'file',
    filesize: '5mb'
  };

  // 支持跨域域名
  config.security = {
    // domainWhiteList: [ 'http://localhost:4200' ],
    // 默认禁用csrf-token
    csrf: {
      enable: false
    }
  };
  // 支持跨域，若设置origin，则security中的白名单失效
  config.cors = {
    // {string|Function} origin: '*',
    // {string|Array} allowMethods: 'GET,HEAD,PUT,POST,DELETE,PATCH'
  };

  // 默认开启数据库，若不用 plugin.js中关闭
  config.sequelize = {
    dialect: 'mysql',
    database: 'fed_pf_test',
    username: 'fed',
    password: 'tuia123',
    host: 'dev.config.duibar.com',
    port: 3306,
    define: {
      underscored: false, // 注意需要加上这个， egg-sequelize只是简单的使用Object.assign对配置和默认配置做了merge, 如果不加这个 update_at会被转变成 updateAt故报错
      // 禁止修改表名，默认情况下，sequelize将自动将所有传递的模型名称（define的第一个参数）转换为复数
      // 但是为了安全着想，复数的转换可能会发生变化，所以禁止该行为
      freezeTableName: true, // 使用自定义表名
      timestamps: false // 去除createAt updateAt
    }
  };

  return config;
};
