module.exports = app => {
  const { router, controller } = app;
  router.get('/', controller.home.index);
  router.get('/error', controller.home.error);
  router.get('/sso/ssoIndex', controller.account.ssoCallback);
  router.get('/sso/findSsoHomeUrl', controller.account.findSsoHomeUrl);
  router.get('/auth/getAuthList', controller.account.getAuthList);
  router.get('/sso/admin/adminInfo', controller.account.adminInfo);
  router.get('/logout', controller.account.logout);
  router.get('/login', controller.account.login);
  router.get('/jwt/verify/:jwt', controller.account.verifyJWT);
};
