const Controller = require('@tuia/tuia-egg').Controller;

class HomeController extends Controller {
  async index() {
    const { ctx } = this;
    if (ctx.cookies.get('sso_ticket')) {
      await ctx.render('index');
    } else {
      ctx.response.redirect('/login');
    }
  }
  async success() {
    const { ctx } = this;
    ctx.success({
      desc: ctx.service.home.sayHello(),
      data: {
        list: [],
        count: 0
      }
    });
  }
  async error() {
    const { ctx } = this;
    ctx.fail({
      error: ctx.ERRCODE.SYSTEM_ERROR,
      desc: '重写错误描述'
    });
  }
}

module.exports = HomeController;
