const Controller = require('@tuia/tuia-egg').Controller;

class AccountController extends Controller {
  async login() {
    const { ctx } = this;
    const ssoHomeURL = await ctx.service.sso.findSsoHomeUrl();
    const loginUrl = `${ssoHomeURL}/login?redirect=http://${ctx.headers.host}&systemId=${ctx.app.config.sso.systemId}`;
    ctx.response.redirect(loginUrl);
  }
  async ssoCallback() {
    const { ctx } = this;
    const { ticket, ssoUserData } = await this.service.sso.ssoCallback();
    if (ssoUserData) {
      // 方法1：此处可以直接存cookie，建议直接服务端重定向索引页或者主页
      // !注意在logout之后清除cookie
      // ctx.cookies.set('u_id', ssoUserData.id);
      // ctx.response.redirect('/');
      // 方法2：处理用户信息之后比如生成JWT返回给前端存到localStorage，然后前端跳转到索引页或者主页，另外将JWT放在header中用于请求后续数据
      // await ctx.render('login-jump', {
      //   jwt: this.ctx.service.jwt.sign(ssoUserData),
      //   target: '/'
      // });
      // 方法3: 存cookie，前端拿到后放到请求头里
      // ctx.cookies.set('jwt', this.ctx.service.jwt.sign(ssoUserData), {
      //   httpOnly: false
      // });
      ctx.response.redirect('/');
    } else {
      if (ticket) {
        // 存在ticket却拿不到ssoUserData的情况
        ctx.response.redirect('/login');
      } else {
        // cookie中无sso_ticket而且向sso服务请求失败的情况
        ctx.status = 500;
      }
    }
  }
  async logout() {
    const { ctx } = this;
    const result = await ctx.service.sso.logout();
    if (result) {
      // ctx.cookies.set('u_id', '');
      // ctx.cookies.set('jwt', '');
      ctx.cookies.set('sso_ticket', '');
      ctx.body = {
        success: true
      };
    } else {
      ctx.status = 500;
      ctx.fail({
        error: ctx.ERRCODE.LOGOUT_FAIL
      });
    }
  }
  async findSsoHomeUrl() {
    const { ctx } = this;
    const result = await ctx.service.sso.findSsoHomeUrl();
    if (result) {
      ctx.body = {
        success: true,
        ssoHomeURL: result
      };
    } else {
      ctx.status = 500;
      ctx.fail({
        error: ctx.ERRCODE.findSsoHomeUrl_FAIL
      });
    }
  }
  async verifyJWT() {
    const { ctx } = this;
    ctx.success({
      data: ctx.service.jwt.verify(ctx.params.jwt)
    });
  }

  async getAuthList() {
    const { ctx } = this;
    ctx.body = {
      success: true,
      authList: [
        'gameManager',
        'gameManager/gameList',
        'gameHallManager',
        'gameHallManager/gameHallList'
      ],
      nowVersion: 1522031458229,
      version: 1522031458229
    };
  }

  async adminInfo() {
    const { ctx } = this;
    const userInfo = await ctx.service.sso.verifyTicketAndGetAdmin();
    if (userInfo) {
      ctx.body = {
        success: true,
        adminName: userInfo.name
      }
    } else {
      ctx.fail({
        error: '查询用户信息失败'
      });
    }
  }
}

module.exports = AccountController;
