import axios from 'axios'
import {
  message
} from 'antd'
import util from './util'

const Axios = axios.create({
  baseURL: '/api/'
})

const base = (opts) => {
  opts = Object.assign({}, {
    data: {},
    params: {}
  }, opts)

  opts.data = util.filterNull(opts.data)
  opts.params = util.filterNull(opts.params)

  return new Promise((resolve, reject) => {
    // message.loading('', 0)
    Axios(opts)
      .then(function (response) {
        return response.data
      })
      .then(function (response) {
        // message.destroy()
        if (response.code === 0) {
          resolve(response.data)
        } else {
          switch (response.code) {
            case 100001:
              window.location.href = '/basics#/login'
              break
            default:
              reject(response.msg)
              message.error(response.msg)
          }
        }
      })
      .catch(function (error) {
        // message.destroy()
        message.error('系统接口错误')
        reject(error)
      })
  })
}

export default base
