import { observable, action } from 'mobx'

import common from 'layers/lib/common'
import permission from 'layers/lib/permission'
import { setLocalStorage } from 'layersWp/utils/helper'

class UserStore {
  @observable dataIsReady = false
  @observable userInfo = {}

  @action
  getUserInfo() {
    const actions = ['/java/auth/getAuthList', '/java/sso/admin/adminInfo']
    Promise.all(
      actions.map(action => {
        return common.fetch(action, {}, 'get')
      })
    ).then(datas => {
      const [authInfoData = {}, userInfoData = {}] = datas
      const { success: getAuthSuccess, authList, message } = authInfoData
      const {
        success: getUserInfoSuccess,
        adminName: name,
        message: userInfoDataMessage
      } = userInfoData
      // 权限数据获取
      if (getAuthSuccess) {
        permission.setPermissions(authList)
      } else {
        common.handleError(message)
      }
      if (getUserInfoSuccess) {
        setLocalStorage('nickname', name)
        this.setUserInfo({
          name
        })
      } else {
        common.handleError(userInfoDataMessage)
      }
      if (getUserInfoSuccess && getAuthSuccess) {
        this.setDataIsReady()
      }
    })
  }
  @action
  setDataIsReady() {
    this.dataIsReady = true
  }
  @action
  setUserInfo(value) {
    this.userInfo = value
  }
}

export default new UserStore()
