import { hashHistory } from 'react-router'
import moment from 'moment'
import 'moment/locale/zh-cn'
import common from 'layers/lib/common'
moment.locale('zh-cn')

const utils = {
  // history跳转
  jumpTo(url) {
    hashHistory.push(url)
  },
  // 登出函数
  logout() {
    common.fetch('/java/sso/systemInfo').then(res => {
      if (res.success) {
        window.location.href = `${res.ssoHomeURL}/login?systemId=${
          res.system.id
        }&redirect=${encodeURIComponent(`${window.location.origin}`)}`
      }
    })
  },
  // 深拷贝
  deepClone(source) {
    if (!source || typeof source !== 'object') {
      throw new Error('error arguments', 'shallowClone')
    }
    var targetObj = source.constructor === Array ? [] : {}
    for (var keys in source) {
      if (source.hasOwnProperty(keys)) {
        if (source[keys] && typeof source[keys] === 'object') {
          targetObj[keys] = source[keys].constructor === Array ? [] : {}
          targetObj[keys] = this.deepClone(source[keys])
        } else {
          targetObj[keys] = source[keys]
        }
      }
    }
    return targetObj
  },
  // 从当前日期修改日期
  // numb为正数时往后numb天，numb为负数时之前的-numb天
  // showString返回值是否是string类型，如果不是返回moment类型
  changeDate(num, showString = false) {
    let result
    if (num > 0) {
      result = moment().add(num, 'days')
    } else {
      result = moment().subtract(Math.abs(num), 'days')
    }
    return showString ? result.format('YYYY-MM-DD') : result
  },
  // 判断是否有值
  isNothing(value) {
    return (
      value === '' ||
      value === undefined ||
      value === null ||
      (typeof value === 'number' && (isNaN(value) || !isFinite(value)))
    )
  },
  // 将数据中增加key字段
  addKey(data) {
    const _data = this.deepClone(data)
    if (_data && _data instanceof Array) {
      return _data.map((val, index) => {
        val.key = Date.now() + index
        return val
      })
    }
  },
  // 将分的数据转换为元，并且保留2位小数
  formatMoney(num) {
    if (this.isNothing(num)) {
      return '-'
    }
    num /= 100
    num = num.toFixed(2)
    num = num.replace(/\B(?=(?:\d{3})+\b)/g, ',')
    return num
  },
  // 拼接URL请求参数
  serialize(obj) {
    const str = []
    for (let p in obj) {
      if (obj.hasOwnProperty(p)) {
        str.push(
          encodeURIComponent(p) +
            '=' +
            encodeURIComponent(this.isNothing(obj[p]) ? '' : obj[p])
        )
      }
    }
    return str.join('&')
  },
  getUrlParams(name) {
    const result =
      decodeURIComponent(
        (new RegExp('[?|&]' + name + '=([^&;]+?)(&|#|;|$)').exec(
          window.location.href
        ) || [undefined, ''])[1].replace(/\+/g, '%20')
      ) || null

    return result
  },
  isWin: navigator.platform === 'Win32' || navigator.platform === 'Windows',
  isMac:
    navigator.platform === 'Mac68K' ||
    navigator.platform === 'MacPPC' ||
    navigator.platform === 'Macintosh' ||
    navigator.platform === 'MacIntel'
}

export default utils
