import React from 'react'
import ReactDom from 'react-dom'
// import * as Sentry from '@sentry/browser'
import zhCN from 'antd/lib/locale-provider/zh_CN'
import { LocaleProvider } from 'antd'

import { configure } from 'mobx'
import { Provider } from 'mobx-react'

import 'layers/styles/antd.less'
import 'layers/styles/index.less'

import { Router, hashHistory } from 'react-router'

import rootRoute from './routes'
import stores from './stores'

configure({ enforceActions: 'observed' })

// Sentry.init({
//   dsn: 'https://7e83b8c577c84200a2687c5991c26057@sentry.dui88.com/9'
// })

ReactDom.render(
  <Provider {...stores}>
    <LocaleProvider locale={zhCN}>
      <Router history={hashHistory} routes={rootRoute} />
    </LocaleProvider>
  </Provider>,
  document.querySelector('#app')
)
