import React, { Component } from 'react'
import {
  Form,
  Row,
  Col,
  Upload,
  message,
  Switch,
  Divider,
  Button,
  Icon,
  Select,
  InputNumber,
  Tabs
} from 'antd'
import styles from '../edits.less'
import ButtonEditStyles from './index.less'
// import { formItemProps } from '../helper'
import { VideoType } from 'layersWp/utils/itemType'
import {
  uploadVideoParamsGen,
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen
} from 'layersWp/config'
import { getNetUrl } from 'layersWp/utils/helper'
import { unset } from 'lodash-es'
import Editor from 'layersWp/constructors/editor'
import { observer, inject } from 'mobx-react'
import defaultAttrs from './attrs'

const Option = Select.Option
const TabPane = Tabs.TabPane
@Editor({
  type: VideoType,
  basic: {
    jump: {}
  },
  attrs: defaultAttrs
})
@inject('WPLayersStore')
@observer
export default class ImageEditor extends Component {
  state = {
    isUploading: false,
    highBitRate: '1200k',
    width: 320,
    height: 180
  }
  render() {
    const { isUploading, highBitRate, width, height } = this.state
    const {
      target,
      WidgetNameCom,
      BasicAttrsCom,
      EventCom,
      ActionCom
    } = this.props
    const { srcImage, srcStrong } = target
    const ImageStyle = Object.assign({}, target.style, {
      maxWidth: '100%',
      maxHeight: '100%'
    })
    unset(ImageStyle, 'width')
    unset(ImageStyle, 'height')
    unset(ImageStyle, 'top')
    unset(ImageStyle, 'left')
    unset(ImageStyle, 'position')
    unset(ImageStyle, 'cursor')
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="视频" key="1">
            <Form layout="inline">
              <Row style={{ margin: '40px 0 8px 0' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row style={{ marginBottom: 20 }}>
                <Col span="8" offset="1" className={ButtonEditStyles.label}>
                  选择基准码率
                </Col>
                <Col offset={1} span={10}>
                  <Select
                    value={highBitRate}
                    onChange={value => this.setState({ highBitRate: value })}
                  >
                    <Option value="1600k">1600kbps</Option>
                    <Option value="1200k">1200kbps</Option>
                    <Option value="768k">768kbps</Option>
                    <Option value="512k">512kbps</Option>
                  </Select>
                </Col>
              </Row>
              <Row type="flex" align="middle" style={{ marginBottom: 20 }}>
                <Col span={8} offset={1}>
                  宽：
                </Col>
                <Col offset={1} span={10}>
                  <InputNumber
                    step={1}
                    value={width}
                    onChange={val => {
                      this.setState({ width: val })
                    }}
                  />
                </Col>
              </Row>
              <Row type="flex" align="middle" style={{ marginBottom: 20 }}>
                <Col span={8} offset={1}>
                  高：
                </Col>
                <Col offset={1} span={10}>
                  <InputNumber
                    step={1}
                    value={height}
                    onChange={val => {
                      this.setState({ height: val })
                    }}
                  />
                </Col>
              </Row>
              <Row style={{ marginBottom: 20 }}>
                <Col span="8" offset="1" className={ButtonEditStyles.label}>
                  视频
                </Col>
                <Col offset={1} span={8}>
                  <div>
                    <Upload
                      {...{
                        ...uploadVideoParamsGen({
                          bitRateList: `250k,${highBitRate}`,
                          resolutionRatio: `${width}x${height}`
                        }),
                        beforeUpload: beforeUploadGen({
                          mimeTypes: 'video/mp4',
                          maxSize: 5
                        }),
                        showUploadList: false,
                        onChange: info => {
                          if (info.file.status === 'error') {
                            message.error('视频上传失败')
                          }
                          if (info.file.status === 'uploading') {
                            this.setState({
                              isUploading: true
                            })
                          }
                          if (info.file.status === 'done') {
                            const {
                              response: { code, data, desc }
                            } = info.file
                            if (code !== '0') {
                              return message.error(desc)
                            }
                            this.setState({
                              isUploading: false
                            })

                            this.props.handleChange({
                              srcStrong: data[highBitRate]
                            })
                            this.props.handleChange({ srcWeak: data['250k'] })
                          }
                        }
                      }}
                    >
                      <Button type="primary">
                        <Icon type="upload" />
                        上传
                      </Button>
                    </Upload>
                  </div>
                </Col>
                <Col span="4" style={{ fontSize: 20 }}>
                  <Icon
                    type={
                      isUploading ? 'loading' : srcStrong ? 'check-circle' : ''
                    }
                    theme={isUploading ? '' : 'twoTone'}
                    twoToneColor="#52c41a"
                  />
                </Col>
              </Row>

              <Divider style={{ margin: '20px 0' }} />
              <Row>
                <Col span="8" offset="1">
                  封面图
                </Col>
                <Col offset={1} span={11}>
                  <div className={ButtonEditStyles['uploader']}>
                    <Upload
                      {...{
                        ...uploadParamsGen(),
                        beforeUpload: beforeUploadGen(),
                        showUploadList: false,
                        onChange: uploadStatusChangeGen(info => {
                          if (info.file.status === 'done') {
                            const netUrl = getNetUrl(info.file.name)
                            this.props.handleChange({
                              srcImage: netUrl
                            })
                          } else if (info.file.status === 'error') {
                            message.error(`${info.file.name}。文件上传失败`)
                          }
                        })
                      }}
                    >
                      <img style={ImageStyle} src={srcImage} />
                    </Upload>
                  </div>
                </Col>
              </Row>
              <Row style={{ marginTop: 20 }}>
                <Col span="8" offset="1">
                  播放控制
                </Col>
                <Col span="11">
                  <Switch
                    checked={
                      target.jump.isBilling === undefined
                        ? true
                        : Boolean(target.jump.isBilling)
                    }
                    onChange={value =>
                      this.props.handleChange({
                        'jump.isBilling': value ? 1 : 0
                      })
                    }
                  />
                </Col>
              </Row>
              {BasicAttrsCom}
            </Form>
          </TabPane>
          {/* <TabPane tab="事件" key="2">
            {EventCom}
          </TabPane> */}
          <TabPane tab="行为" key="3">
            {ActionCom}
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
