import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Select } from 'antd'
import styles from '../edits.less'
import { formItemProps } from '../helper'
import { TextType as type } from 'layersWp/utils/itemType'
import Editor from 'layersWp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import ColorPicker from 'layers/components/color-picker'
import RichEditor from 'layers/components/rich-editor'
import TextStyles from './index.less'
import Divider from 'layersWp/constructors/fc/divider'
import defaultAttrs from './attrs'
// import TuiaIcon from 'layersWp/constructors/fc/icon'

const FormItem = Form.Item
const TabPane = Tabs.TabPane
const { Option } = Select

@Editor({
  type,
  basic: {
    jump: {}
  },
  attrs: defaultAttrs
})
@inject('WPLayersStore')
@observer
export default class TextEditor extends Component {
  handleFastStyleClick = (props, borderRadius) => {
    props.handleChange({
      'style.borderBottomLeftRadius': borderRadius,
      'style.borderBottomRightRadius': borderRadius,
      'style.borderTopLeftRadius': borderRadius,
      'style.borderTopRightRadius': borderRadius
    })
  }

  render() {
    const {
      target,
      BasicAttrsCom,
      handleChange,
      WidgetNameCom,
      FixedAttrCom,
      EventCom,
      ActionCom
      // JumpCom
    } = this.props
    const { style, text } = target
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="文字" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Divider />
              <FormItem label="动态文案" {...formItemProps}>
                <Select
                  value={target.dynamicText}
                  onChange={value =>
                    this.props.handleChange({ dynamicText: value })
                  }
                >
                  <Option value={'none'}>无</Option>
                  <Option value={'ip-province'}>省</Option>
                  <Option value={'ip-city'}>市</Option>
                </Select>
              </FormItem>
              <RichEditor
                className={TextStyles.rich_editor}
                excludeControls={[
                  'separator',
                  'superscript',
                  'subscript',
                  'remove-styles',
                  'emoji',
                  'text-indent',
                  'headings',
                  'list-ul',
                  'list-ol',
                  'blockquote',
                  'code',
                  'link',
                  'hr',
                  'media',
                  'clear'
                ]}
                value={text}
                onChange={editorState => {
                  let html = editorState.toHTML()
                  handleChange({
                    text: html
                  })
                }}
              />
              <Divider />
              <FormItem label="背景颜色" {...formItemProps}>
                <Row type="flex" justify="center" align="middle">
                  <Col span={6}>
                    <ColorPicker
                      value={style.backgroundColor}
                      onChange={color =>
                        handleChange({ 'style.backgroundColor': color })
                      }
                    />
                  </Col>
                  <Col offset={4} span={8} style={{ textAlign: 'center' }}>
                    文字颜色
                  </Col>
                  <Col span={6}>
                    <ColorPicker
                      value={style.color}
                      onChange={color => handleChange({ 'style.color': color })}
                    />
                  </Col>
                </Row>
              </FormItem>
              <div style={{ marginBottom: 8 }} />
              {BasicAttrsCom}
              {FixedAttrCom}
            </Form>
          </TabPane>
          <TabPane tab="行为" key="3">
            {ActionCom}
          </TabPane>
          {/* <TabPane tab="点击" key="2">
            {JumpCom}
          </TabPane> */}
        </Tabs>
      </div>
    )
  }
}
