/**
 * @author allen bai
 * @email bairongyu@tuia.cn
 * @create date 2020-03-03 14:26:48
 * @modify date 2020-03-03 14:26:48
 * @desc spirit-animation部件配置文件
 */

import { SpiritAnimation } from 'layersWp/utils/itemType'
import { staticResourcePrefix } from 'layersWp/config'

export default {
  type: SpiritAnimation,
  style: {
    width: '200px',
    height: '200px',
    transform: 'rotate(0deg)',
    backgroundImage: `url("${staticResourcePrefix}/df_image_widget@1x.png")`,
    backgroundSize: '100% 100%',
    backgroundPosition: 'center'
  },
  name: '精灵动画',
  jump: {
    type: 'link',
    android: '',
    ios: '',
    popupId: '',
    isCoversion: 1,
    isBilling: 1
  },
  fixed: 0,
  spiritAnimation: {
    // 是否循环播放
    isLoop: false,
    // 动画帧数
    frameNumber: 1,
    // 单帧时长（S）
    durationPerFrame: 0.1,
    // 图片原始尺寸大小
    imageOriginSize: {
      width: 100,
      height: 100
    },
    // 是否加载图片
    imageLoaded: false
  },
  eventAttrs: {
    eventClick: {
      des: '点击事件'
    }
  },
  actionAttrs: {
    actionShow: {
      des: '显示元素'
    },
    actionHide: {
      des: '隐藏元素'
    }
  }
}
