import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Upload, message, Select } from 'antd'
import styles from '../edits.less'
import ButtonEditStyles from './index.less'
import { formItemProps } from '../helper'
import { ImageType } from 'layersWp/utils/itemType'
import {
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen,
  staticResourcePrefix
} from 'layersWp/config'
import { getNetUrl, readImageProps } from 'layersWp/utils/helper'
import { unset } from 'lodash-es'
import Editor from 'layersWp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import defaultAttrs from './attrs'

const FormItem = Form.Item
const TabPane = Tabs.TabPane
const Option = Select.Option

@Editor({
  type: ImageType,
  basic: {
    jump: {}
  },
  attrs: defaultAttrs
})
@inject('WPLayersStore')
@observer
export default class ImageEditor extends Component {
  handleFastStyleClick = (props, borderRadius) => {
    props.handleChange({
      'style.borderBottomLeftRadius': borderRadius,
      'style.borderBottomRightRadius': borderRadius,
      'style.borderTopLeftRadius': borderRadius,
      'style.borderTopRightRadius': borderRadius
    })
  }

  render() {
    const {
      target,
      BasicAttrsCom,
      WidgetNameCom,
      FixedAttrCom,
      JumpCom,
      EventCom,
      ActionCom
    } = this.props
    const ImageStyle = Object.assign({}, target.style, {
      maxWidth: '100%',
      maxHeight: '100%'
    })
    unset(ImageStyle, 'width')
    unset(ImageStyle, 'height')
    unset(ImageStyle, 'top')
    unset(ImageStyle, 'left')
    unset(ImageStyle, 'position')
    unset(ImageStyle, 'cursor')
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="图片" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row>
                <Col offset={1} span={22}>
                  <div
                    className={ButtonEditStyles['uploader']}
                    style={{
                      backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")`
                    }}
                  >
                    <Upload
                      {...{
                        ...uploadParamsGen(),
                        beforeUpload: beforeUploadGen(),
                        showUploadList: false,
                        onChange: uploadStatusChangeGen(info => {
                          if (info.file.status === 'done') {
                            const netUrl = getNetUrl(info.file.name)
                            const { dpr } = this.props.WPLayersStore.scene
                            this.props.handleChange({
                              'style.backgroundImage': `url("${netUrl}")`
                            })
                            // resize图片尺寸
                            readImageProps(netUrl).then(res => {
                              this.props.handleChange({
                                'style.width': res.width / dpr + 'px',
                                'style.height': res.height / dpr + 'px'
                              })
                            })
                          } else if (info.file.status === 'error') {
                            message.error(`${info.file.name}。文件上传失败`)
                          }
                        })
                      }}
                    >
                      <img
                        src={ImageStyle.backgroundImage.replace(
                          /url\("([\s\S]*)"\)/,
                          (_, matches) => matches
                        )}
                        style={ImageStyle}
                      />
                    </Upload>
                  </div>
                </Col>
              </Row>

              <Col style={{ width: '60px' }} />
              <FormItem label="动画设置" {...formItemProps}>
                <Select
                  value={target.animation.type}
                  onChange={value =>
                    this.props.handleChange({ 'animation.type': value })
                  }
                >
                  <Option value={'none'}>无</Option>
                  <Option value={'breathe'}>呼吸</Option>
                  <Option value={'swing'}>摇摆</Option>
                </Select>
              </FormItem>
              {BasicAttrsCom}
              {FixedAttrCom}
            </Form>
          </TabPane>
          <TabPane tab="点击" key="2">
            {JumpCom}
          </TabPane>
          <TabPane tab="事件" key="3">
            {EventCom}
          </TabPane>
          <TabPane tab="行为" key="4">
            {ActionCom}
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
