import React, { Component } from 'react'
import styles from './index.less'
import {
  Row,
  Col,
  Input,
  InputNumber,
  Radio,
  Select,
  Upload,
  Switch
} from 'antd'
import CommonStyle from 'layersWp/config/commonStyle'
import ColorPicker from 'layers/components/color-picker'
import store from 'layersWp/store'
import { pxFormatter } from '../../helper'
import { PopupType } from 'layersWp/utils/itemType'
import { observer } from 'mobx-react'
import {
  uploadParamsGen,
  uploadStatusChangeGen,
  beforeUploadGen,
  staticResourcePrefix
} from 'layersWp/config'
import { getNetUrl, readImageProps } from 'layersWp/utils/helper'

const Col1Props = {
  offset: 1,
  span: 6,
  style: {
    textAlign: 'right'
  }
}

const Col2Props = {
  span: 14,
  offset: 1
}

const RowProps = {
  type: 'flex',
  align: 'middle',
  style: {
    marginBottom: 9
  }
}

const RadioGroup = Radio.Group
const Option = Select.Option

@observer
export default class SubmitVerify extends Component {
  constructor(props) {
    super(props)
    this.state = {
      typeError: '',
      sizeError: ''
    }
  }
  handleFastClick = radius => {
    this.props.handleChange({
      'submitVerify.style.borderRadius': `${radius}px`,
      'submitVerify.style.backgroundImage': '',
      'submitVerify.style.width': '100%',
      'submitVerify.style.height': '43px',
      'submitVerify.style.backgroundColor': '#FF8200',
      'submitVerify.text': '立即领取'
    })
  }
  render() {
    const { dpr } = store.WPLayersStore.scene
    const { submitVerify, handleChange } = this.props
    let backgroundImage = submitVerify.style.backgroundImage
    return (
      <div className={styles['submit-verify']}>
        <div className={styles['options']}>
          <Row {...RowProps}>
            <Col {...Col1Props}>快捷样式</Col>
            <Col {...Col2Props} className={styles['fast-style']}>
              {(() =>
                [0, 8, 32].map((item, index) => {
                  return (
                    <div
                      key={index}
                      style={{
                        borderColor:
                          submitVerify.style.borderRadius === `${item}px` &&
                          CommonStyle['@primary-color'],
                        backgroundImage: `url(//yun.tuia.cn/tuia/jimo-web-pro/radius-${item}px.svg)`,
                        backgroundSize: 'cover'
                      }}
                      onClick={() => this.handleFastClick(item)}
                    />
                  )
                }))()}
            </Col>
          </Row>
          <Row {...RowProps}>
            <Col {...Col1Props}>按钮文字</Col>
            <Col {...Col2Props}>
              <Input
                value={submitVerify.text}
                onChange={e =>
                  handleChange({
                    'submitVerify.text': e.target.value
                  })
                }
              />
            </Col>
          </Row>
          <Row {...RowProps}>
            <Col {...Col1Props}>按钮颜色</Col>
            <Col {...Col2Props} style={{ width: 56 }}>
              <ColorPicker
                placement="right"
                value={submitVerify.style.backgroundColor}
                onChange={value =>
                  handleChange({
                    'submitVerify.style.backgroundColor': value
                  })
                }
              />
            </Col>
          </Row>
          <Row {...RowProps}>
            <Col {...Col1Props}>按钮距离表单</Col>
            <Col {...Col2Props}>
              <InputNumber
                style={{ width: 56 }}
                value={submitVerify.dis}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                onChange={value =>
                  console.log(value) ||
                  handleChange({ 'submitVerify.dis': value })
                }
              />
            </Col>
          </Row>
          <Row {...RowProps}>
            <Col {...Col1Props}>开启提交验证</Col>
            <Col {...Col2Props}>
              <RadioGroup
                value={submitVerify.enable}
                onChange={e =>
                  handleChange({
                    'submitVerify.enable': e.target.value
                  })
                }
              >
                <Radio value={1}>开启</Radio>
                <Radio value={0}>关闭</Radio>
              </RadioGroup>
            </Col>
          </Row>
          <Row {...RowProps}>
            <Col {...Col1Props}>跳转方式</Col>
            <Col {...Col2Props}>
              <Select
                value={submitVerify.jump.type}
                style={{ width: '100%' }}
                onChange={value =>
                  handleChange({ 'submitVerify.jump.type': value })
                }
              >
                <Option value="link">跳转链接</Option>
                {/* <Option value="popup">弹层</Option> */}
              </Select>
            </Col>
          </Row>
          {/* {submitVerify.jump.type === 'link' && (
            <React.Fragment>
              <Row {...RowProps}>
                <Col {...Col1Props}>
                  跳转链接
                  <br />
                  (Android)
                </Col>
                <Col {...Col2Props}>
                  <Input
                    value={submitVerify.jump.android}
                    onChange={e =>
                      handleChange({
                        'submitVerify.jump.android': e.target.value
                      })
                    }
                  />
                </Col>
              </Row>
              <Row {...RowProps}>
                <Col {...Col1Props} />
                <Col {...Col2Props}>
                  <WXD
                    value={submitVerify.jump.is206Jump}
                    onChange={e =>
                      handleChange({
                        'submitVerify.jump.is206Jump': Number(e.target.checked)
                      })
                    }
                  />
                </Col>
              </Row>
              <Row {...RowProps}>
                <Col {...Col1Props}>
                  跳转链接
                  <br />
                  (iOS)
                </Col>
                <Col {...Col2Props}>
                  <Input
                    value={submitVerify.jump.ios}
                    onChange={e =>
                      handleChange({ 'submitVerify.jump.ios': e.target.value })
                    }
                  />
                </Col>
              </Row>
            </React.Fragment>
          )} */}
          {submitVerify.jump.type === 'popup' && (
            <Row {...RowProps}>
              <Col {...Col1Props}>选择弹层</Col>
              <Col {...Col2Props}>
                <Select
                  value={submitVerify.jump.popupId}
                  style={{ width: '100%' }}
                  onChange={value =>
                    handleChange({ 'submitVerify.jump.popupId': value })
                  }
                >
                  <Option key={100} value="">
                    无
                  </Option>
                  {[...store.WPLayersStore.itemList].map((item, index) => {
                    if (item.widgetType === PopupType) {
                      let attrs = item[item.widgetType]
                      return (
                        <Option key={index} value={attrs.id}>
                          {attrs.name}
                        </Option>
                      )
                    }
                  })}
                </Select>
              </Col>
            </Row>
          )}
          <Row {...RowProps}>
            <Col {...Col1Props}>设为转化</Col>
            <Col {...Col2Props}>
              <Switch
                checked={
                  submitVerify.jump.isCoversion === undefined
                    ? true
                    : Boolean(submitVerify.jump.isCoversion)
                }
                onChange={value =>
                  handleChange({
                    'submitVerify.jump.isCoversion': value ? 1 : 0
                  })
                }
              />
            </Col>
          </Row>
        </div>
        <div className={styles['display']}>
          <div
            className={styles['image']}
            style={{
              backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")`
            }}
          >
            {!backgroundImage ? (
              <div style={{ margin: '0 16px', ...submitVerify.style }}>
                {submitVerify.text}
              </div>
            ) : (
              <img
                src={backgroundImage.replace(
                  /url\("([\s\S]*)"\)/,
                  (_, matches) => matches
                )}
                style={{ maxWidth: '100%', maxHeight: '100%' }}
              />
            )}
          </div>
          <div className={styles['upload']}>
            <Upload
              {...{
                ...uploadParamsGen(),
                showUploadList: false,
                beforeUpload: beforeUploadGen({
                  onEnd: ({ typeError, sizeError }) => {
                    this.setState({
                      sizeError,
                      typeError
                    })
                  }
                }),
                onChange: uploadStatusChangeGen(info => {
                  if (info.file.status === 'done') {
                    const netUrl = getNetUrl(info.file.name)
                    this.props.handleChange({
                      'submitVerify.style.backgroundImage': `url("${netUrl}")`,
                      'submitVerify.style.borderRadius': 0,
                      'submitVerify.style.backgroundColor': 'rgba(0,0,0,0)',
                      'submitVerify.text': ''
                    })
                    // resize图片尺寸
                    readImageProps(netUrl).then(res => {
                      this.props.handleChange({
                        'submitVerify.style.width': res.width / dpr + 'px',
                        'submitVerify.style.height': res.height / dpr + 'px'
                      })
                    })
                  }
                })
              }}
            >
              <a>上传图片</a>
            </Upload>
          </div>
          <div className={styles['tips']}>
            <div>建议尺寸：参考表单宽度 </div>
            <div
              style={{
                color: this.state.typeError
                  ? CommonStyle['@primary-assist-color']
                  : CommonStyle['@third-font-color']
              }}
            >
              上传格式：JPG/JPEG/PNG/GIF
            </div>
            <div
              style={{
                color: this.state.sizeError
                  ? CommonStyle['@primary-assist-color']
                  : CommonStyle['@third-font-color']
              }}
            >
              文件大小：&lt; 500K
            </div>
          </div>
        </div>
      </div>
    )
  }
}
