import React, { Component } from 'react'
import { Form, Input, Select, Radio, Button } from 'antd'
import { formItemProps } from './helper'
import Divider from 'layersWp/constructors/fc/divider'
import { typeOptions } from '../common'
import styles from './index.less'
import generateDefaultAttrs from '../default'

const FormItem = Form.Item
const Option = Select.Option
const RadioGroup = Radio.Group
const type = 'select'
const { TextArea } = Input

function PlaceholderDiv({ height }) {
  return <div style={{ height }} />
}

export default class SelectEditor extends Component {
  constructor(props) {
    super(props)
    this.state = {
      data: { ...this.props.data }
    }
  }
  handleChange = (key, value) => {
    let data = {}
    if (key === 'childType') {
      let type = `select$$`
      data = generateDefaultAttrs(`${type}${value}`)
    } else {
      data = Object.assign({}, this.state.data, {
        [key]: value
      })
    }
    this.setState({ data })
  }
  handleClick = () => {
    this.props.handleChange(this.state.data)
    this.props.closeDrawer()
  }
  render() {
    const { childType, title, placeholder, required, options } = this.state.data
    return (
      <div className={styles['form']}>
        <Form layout="inline" className={styles['form-inner']}>
          <FormItem label="表单类型" {...formItemProps}>
            <Select
              value={childType}
              style={{ width: 160 }}
              onChange={value => this.handleChange('childType', value)}
            >
              {typeOptions
                .filter(item => {
                  return item.value.split('$$')[0] === type
                })
                .map((item, index) => {
                  return (
                    <Option key={index} value={item.value.split('$$')[1]}>
                      {item.text}
                    </Option>
                  )
                })}
            </Select>
          </FormItem>
          <FormItem label="表单标题" {...formItemProps}>
            <Input
              value={title}
              placeholder="最多20个字符"
              maxLength={20}
              onChange={e => this.handleChange('title', e.target.value)}
            />
          </FormItem>
          <FormItem label="提示文字" {...formItemProps}>
            <Input
              value={placeholder}
              onChange={e => this.handleChange('placeholder', e.target.value)}
            />
          </FormItem>
          <FormItem label="是否必填" {...formItemProps}>
            <RadioGroup
              value={required}
              onChange={e => this.handleChange('required', e.target.value)}
            >
              <Radio value={1}>是</Radio>
              <Radio value={0}>否</Radio>
            </RadioGroup>
          </FormItem>
          {childType === 'customize' && (
            <React.Fragment>
              <PlaceholderDiv height={16} />
              <Divider />
              <PlaceholderDiv height={14} />
              <FormItem label="选项标签" {...formItemProps}>
                <TextArea
                  value={(options || []).join('\n')}
                  rows={4}
                  placeholder={`一行一个值，例如：\r\n红色\r\n蓝色`}
                  onChange={e =>
                    this.handleChange('options', e.target.value.split(/\n/))
                  }
                />
              </FormItem>
            </React.Fragment>
          )}
        </Form>
        <Button
          type="primary"
          className={styles['button']}
          onClick={this.handleClick}
          block
        >
          保存
        </Button>
      </div>
    )
  }
}
