import React, { Component } from 'react'
import Checkbox from './checkbox'
import Radio from './radio'
import Input from './input'
import Select from './select'
import TextArea from './textarea'
import { deepClone } from 'layersWp/utils/helper'

const style = {
  position: 'absolute',
  top: 0,
  bottom: 0,
  right: 0,
  width: 386,
  backgroundColor: '#fff',
  // transition: 'all .2s cubic-bezier(0.78, 0.14, 0.15, 0.86) 0',
  zIndex: 2
}

export default class FormTypeEditor extends Component {
  closeDrawer = () => {
    this.props.changeState({
      index: null,
      data: null
    })
  }
  handleEntryChange = entry => {
    const { index, handleChange } = this.props
    handleChange({
      [`controlSetting.${index}`]: deepClone(entry)
    })
  }
  render() {
    let { data } = this.props
    const isShow = data
    const { type } = data || {}
    let Com = null
    switch (type) {
      case 'checkbox':
        Com = Checkbox
        break
      case 'radio':
        Com = Radio
        break
      case 'input':
        Com = Input
        break
      case 'select':
        Com = Select
        break
      case 'textarea':
        Com = TextArea
        break
    }
    return (
      <React.Fragment>
        {isShow && (
          <div
            style={{
              position: 'absolute',
              top: 0,
              left: 0,
              right: 0,
              bottom: 0,
              backgroundColor: 'rgba(0,0,0,.2)',
              zIndex: 1
            }}
            onClick={this.closeDrawer}
          />
        )}
        <div
          className="animated faster"
          style={Object.assign({}, style, {
            right: isShow ? 0 : '-100%',
            animationDuration: '400ms'
          })}
        >
          {Com && (
            <Com
              data={data}
              handleChange={this.handleEntryChange}
              closeDrawer={this.closeDrawer}
            />
          )}
        </div>
      </React.Fragment>
    )
  }
}
