import React, { Component } from 'react'
import Widget from 'layersWp/constructors/widget/index'
import styles from './index.less'
@Widget()
export default class FlopWidget extends Component {
  render() {
    const { cards, image } = this.props.widgetAttrs
    const { width, height, left, top } = image
    return (
      <div className={styles.flop}>
        <img
          src={image.src}
          style={{
            width,
            height,
            left,
            top,
            position: 'absolute',
            zIndex: -1,
            marginLeft: 0
          }}
          alt=""
        />
        {cards.map((card, i) => (
          <img
            src={card.frontImage}
            style={{ opacity: card.opacity }}
            key={i}
          />
        ))}
      </div>
    )
  }
}
