import React, { Component } from 'react'
import {
  Form,
  Tabs,
  Row,
  Col,
  Select,
  InputNumber,
  Upload,
  message,
  Divider
} from 'antd'
import { formItemProps, getNumber } from '../helper'
import styles from '../edits.less'
import flopStyles from './index.less'

import { FlopType } from 'layersWp/utils/itemType'
import { unset } from 'lodash-es'
import Editor from 'layersWp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import {
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen
} from 'layersWp/config'
import { getNetUrl, readImageProps } from 'layersWp/utils/helper'
import CardEditor from './cardEditor'

const FormItem = Form.Item
const TabPane = Tabs.TabPane
const Option = Select.Option

@Editor({
  type: FlopType,
  basic: {
    jump: {}
  }
})
@inject('WPLayersStore')
@observer
export default class FlopEditor extends Component {
  handleFastStyleClick = (props, borderRadius) => {
    props.handleChange({
      'style.borderBottomLeftRadius': borderRadius,
      'style.borderBottomRightRadius': borderRadius,
      'style.borderTopLeftRadius': borderRadius,
      'style.borderTopRightRadius': borderRadius
    })
  }

  render() {
    const { target, BasicAttrsCom, WidgetNameCom, FixedAttrCom } = this.props
    const { dpr } = this.props.WPLayersStore.scene
    const ImageStyle = Object.assign({}, target.style, {
      maxWidth: '100%',
      maxHeight: '100%'
    })
    unset(ImageStyle, 'width')
    unset(ImageStyle, 'height')
    unset(ImageStyle, 'top')
    unset(ImageStyle, 'left')
    unset(ImageStyle, 'position')
    unset(ImageStyle, 'cursor')
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="图片" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <FormItem label="初始动效" {...formItemProps}>
                <Select
                  value={target.initialAnimation.type}
                  onChange={value =>
                    this.props.handleChange({ 'initialAnimation.type': value })
                  }
                >
                  <Option value={'none'}>无</Option>
                  <Option value={'inTurn'}>交替闪烁</Option>
                </Select>
              </FormItem>
              <FormItem label="翻转动效" {...formItemProps}>
                <Select
                  value={target.flopAnimation.type}
                  onChange={value =>
                    this.props.handleChange({ 'flopAnimation.type': value })
                  }
                >
                  <Option value={'beat'}>跳动翻转</Option>
                  <Option value={'direct'}>直接翻转</Option>
                </Select>
              </FormItem>
              <FormItem label="跳转延迟" {...formItemProps}>
                <InputNumber
                  value={target.jump.delay}
                  min={0}
                  style={{ width: '48px' }}
                  onChange={value =>
                    this.props.handleChange({ 'jump.delay': value })
                  }
                />
              </FormItem>
              <CardEditor
                target={target}
                dpr={dpr}
                filed="cards[0]"
                label="中奖图片"
                handleChange={this.props.handleChange}
              />
              <CardEditor
                target={target}
                dpr={dpr}
                filed="cards[1]"
                label="对比图1"
                handleChange={this.props.handleChange}
              />
              <CardEditor
                target={target}
                dpr={dpr}
                filed="cards[2]"
                label="对比图2"
                handleChange={this.props.handleChange}
              />
              <Divider />
              <Row>
                <Col offset={1}>利益点图片</Col>
              </Row>
              <Row>
                <Col offset={3}>
                  <Upload
                    {...{
                      ...uploadParamsGen(),
                      beforeUpload: beforeUploadGen(),
                      showUploadList: false,
                      onChange: uploadStatusChangeGen(info => {
                        if (info.file.status === 'done') {
                          const netUrl = getNetUrl(info.file.name)
                          this.props.handleChange({
                            'image.src': netUrl
                          })
                          // resize图片尺寸
                          readImageProps(netUrl).then(res => {
                            this.props.handleChange({
                              'image.height': res.height / dpr + 'px',
                              'image.width': res.width / dpr + 'px',
                              'image.left':
                                (getNumber(target.style.width) -
                                  res.width / dpr) /
                                  2 +
                                'px'
                            })
                          })
                        } else if (info.file.status === 'error') {
                          message.error(`${info.file.name}。文件上传失败`)
                        }
                      })
                    }}
                  >
                    <img
                      className={flopStyles.uploader}
                      style={{ width: 200 }}
                      src={target.image.src}
                    />
                  </Upload>
                </Col>
              </Row>
              <Row
                type="flex"
                align="middle"
                justify="center"
                style={{
                  height: 39,
                  fontSize: 12,
                  color: 'rgba(0, 0, 0, 0.85)',
                  marginBottom: 20
                }}
              >
                <Col span={2}>X</Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(target.image.left) * dpr}
                    style={{ width: '100%' }}
                    step={dpr}
                    onChange={value =>
                      this.props.handleChange({
                        'image.left': value / dpr + 'px'
                      })
                    }
                  />
                </Col>
                <Col span={2} offset={3}>
                  Y
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(target.image.top) * dpr}
                    style={{ width: '100%' }}
                    step={dpr}
                    onChange={value =>
                      this.props.handleChange({
                        'image.top': value / dpr + 'px'
                      })
                    }
                  />
                </Col>
              </Row>
              <FormItem label="动画设置" {...formItemProps}>
                <Select
                  value={target.image.animation.type}
                  onChange={value =>
                    this.props.handleChange({ 'image.animation.type': value })
                  }
                >
                  <Option value={'none'}>无</Option>
                  <Option value={'breathe'}>呼吸</Option>
                  <Option value={'swing'}>摇摆</Option>
                </Select>
              </FormItem>
              {BasicAttrsCom}
              {FixedAttrCom}
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
